/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.SwingUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.util.Vector;

class SwingGraphics
extends Graphics {
    Graphics graphics;
    Rectangle clipRect;
    static final int poolSize = 20;
    private static int needsSetClip = -1;
    private static final Object graphicsPoolKey = class$com$sun$java$swing$SwingGraphics != null ? class$com$sun$java$swing$SwingGraphics : (class$com$sun$java$swing$SwingGraphics = SwingGraphics.class$("com.sun.java.swing.SwingGraphics"));
    static /* synthetic */ Class class$com$sun$java$swing$SwingGraphics;

    public Graphics create() {
        return SwingGraphics.createSwingGraphics(this.graphics.create());
    }

    public Graphics subGraphics() {
        return this.graphics;
    }

    SwingGraphics(Graphics graphics) {
        this.init(graphics);
    }

    void init(Graphics graphics) {
        if (graphics == null) {
            Thread.currentThread();
            Thread.dumpStack();
        }
        this.graphics = graphics;
        this.clipRect = graphics.getClipBounds();
        if (this.clipRect == null) {
            this.clipRect = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    public static SwingGraphics createSwingGraphics(Graphics graphics) {
        if (graphics == null) {
            return null;
        }
        if (graphics instanceof SwingGraphics) {
            return (SwingGraphics)graphics;
        }
        SwingGraphics swingGraphics = SwingGraphics.getRecycledSwingGraphics();
        if (swingGraphics != null) {
            swingGraphics.init(graphics);
        } else {
            swingGraphics = new SwingGraphics(graphics);
        }
        return swingGraphics;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        return SwingGraphics.createSwingGraphics(SwingGraphics.createGraphics(this.graphics, n, n2, n3, n4));
    }

    static Graphics createGraphics(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create(n, n2, n3, n4);
        if (needsSetClip != 0) {
            Rectangle rectangle = graphics.getClipBounds();
            int n5 = rectangle.x > n ? rectangle.x - n : 0;
            int n6 = rectangle.y > n2 ? rectangle.y - n2 : 0;
            int n7 = Math.min(n + n3, rectangle.x + rectangle.width) - Math.max(n, rectangle.x);
            int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height) - Math.max(n2, rectangle.y);
            if (needsSetClip == -1 && (n > 0 || n2 > 0)) {
                Rectangle rectangle2 = graphics2.getClipBounds();
                needsSetClip = rectangle2.x != n5 || rectangle2.y != n6 || rectangle2.width != n7 || rectangle2.height != n8 ? 1 : 0;
            }
            graphics2.setClip(n5, n6, n7, n8);
        }
        return graphics2;
    }

    public void translate(int n, int n2) {
        this.graphics.translate(n, n2);
    }

    public Color getColor() {
        return this.graphics.getColor();
    }

    public void setColor(Color color) {
        this.graphics.setColor(color);
    }

    public void setPaintMode() {
        this.graphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.graphics.setXORMode(color);
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public void setFont(Font font) {
        this.graphics.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public boolean isClipIntersecting(Rectangle rectangle) {
        if (this.clipRect.x >= rectangle.x + rectangle.width || this.clipRect.x + this.clipRect.width <= rectangle.x || this.clipRect.y >= rectangle.y + rectangle.height || this.clipRect.y + this.clipRect.height <= rectangle.y) {
            return false;
        }
        return this.clipRect.width != 0 && this.clipRect.height != 0 && rectangle.width != 0 && rectangle.height != 0;
    }

    public int getClipX() {
        return this.clipRect.x;
    }

    public int getClipY() {
        return this.clipRect.y;
    }

    public int getClipWidth() {
        return this.clipRect.width;
    }

    public int getClipHeight() {
        return this.clipRect.height;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.graphics.clipRect(n, n2, n3, n4);
        this._changeClip(n, n2, n3, n4, false);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.graphics.setClip(n, n2, n3, n4);
        this._changeClip(n, n2, n3, n4, true);
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public void setClip(Shape shape) {
        this.graphics.setClip(shape);
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this._changeClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.graphics.clearRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void drawString(String string, int n, int n2) {
        this.graphics.drawString(string, n, n2);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public void dispose() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        this.recycle();
    }

    public void recycle() {
        this.graphics = null;
        SwingGraphics.recycleSwingGraphics(this);
    }

    private void _changeClip(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.clipRect.x = n;
            this.clipRect.y = n2;
            this.clipRect.width = n3;
            this.clipRect.height = n4;
            return;
        }
        SwingUtilities.computeIntersection(n, n2, n3, n4, this.clipRect);
    }

    private static synchronized void recycleSwingGraphics(SwingGraphics swingGraphics) {
        Vector<SwingGraphics> vector = (Vector<SwingGraphics>)SwingUtilities.appContextGet(graphicsPoolKey);
        if (vector == null) {
            vector = new Vector<SwingGraphics>(20);
            SwingUtilities.appContextPut(graphicsPoolKey, vector);
        }
        if (vector.size() < 20) {
            vector.addElement(swingGraphics);
        }
    }

    private static synchronized SwingGraphics getRecycledSwingGraphics() {
        SwingGraphics swingGraphics = null;
        Vector vector = (Vector)SwingUtilities.appContextGet(graphicsPoolKey);
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        if (n > 0) {
            swingGraphics = (SwingGraphics)vector.elementAt(n - 1);
            vector.removeElementAt(n - 1);
        }
        return swingGraphics;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

