/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.DefaultButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ButtonUI;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

public class JToggleButton
extends AbstractButton
implements Accessible {
    public JToggleButton() {
        this(null, null, false);
    }

    public JToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JToggleButton(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JToggleButton(String string) {
        this(string, null, false);
    }

    public JToggleButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public JToggleButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public JToggleButton(String string, Icon icon, boolean bl) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(bl);
        this.init(string, icon);
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ToggleButtonUI";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        public boolean isSelected() {
            if (this.group != null) {
                return this.group.isSelected(this);
            }
            return (this.stateMask & 2) != 0;
        }

        public void setSelected(boolean bl) {
            if (this.group != null) {
                this.group.setSelected(this, bl);
            } else {
                this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            }
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        public void setPressed(boolean bl) {
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }

        AccessibleJToggleButton() {
            JToggleButton.this = JToggleButton.this;
        }
    }
}

