/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.Action;
import com.sun.java.swing.AncestorNotifier;
import com.sun.java.swing.Autoscroller;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.DebugGraphics;
import com.sun.java.swing.FocusManager;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.JToolTip;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.RepaintManager;
import com.sun.java.swing.SwingGraphics;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import com.sun.java.swing.event.AncestorListener;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.plaf.ComponentUI;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public abstract class JComponent
extends Container
implements Serializable {
    private Dimension preferredSize;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Float alignmentX;
    private Float alignmentY;
    private AncestorNotifier ancestorNotifier;
    Rectangle _bounds = new Rectangle();
    protected ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private Hashtable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private Autoscroller autoscroller;
    private int flags;
    private Border border;
    private transient Rectangle tmpRect;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private static final int REQUEST_FOCUS_DISABLED = 0;
    private static final int IS_DOUBLE_BUFFERED = 1;
    private static final int ANCESTOR_USING_BUFFER = 2;
    private static final int IS_PAINTING_TILE = 3;
    private static final int HAS_FOCUS = 4;
    private static final int IS_OPAQUE = 5;
    protected AccessibleContext accessibleContext;
    private PropertyChangeSupport changeSupport;
    static /* synthetic */ Class class$com$sun$java$swing$JComponent$KeyboardState;

    public JComponent() {
        this.enableEvents(4L);
    }

    public void updateUI() {
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.invalidate();
        this.firePropertyChange("UI", componentUI2, this.ui);
    }

    public String getUIClassID() {
        return "not a pluggable look and feel class";
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            if (graphics instanceof SwingGraphics) {
                if (!(((SwingGraphics)graphics).subGraphics() instanceof DebugGraphics)) {
                    graphics2 = new DebugGraphics(((SwingGraphics)graphics).subGraphics(), this);
                    graphics2 = SwingGraphics.createSwingGraphics(graphics2);
                }
            } else {
                graphics2 = new DebugGraphics(graphics, this);
            }
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            SwingGraphics swingGraphics = SwingGraphics.createSwingGraphics(graphics.create());
            try {
                this.ui.update(swingGraphics, this);
                return;
            }
            finally {
                Object var4_3 = null;
                ((Graphics)swingGraphics).dispose();
            }
        }
    }

    protected void paintChildren(Graphics graphics) {
        SwingGraphics swingGraphics;
        boolean bl = false;
        if (graphics instanceof SwingGraphics) {
            swingGraphics = (SwingGraphics)graphics;
        } else {
            swingGraphics = SwingGraphics.createSwingGraphics(graphics);
            bl = true;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getComponentCount() - 1;
            while (n >= 0) {
                Component component = this.getComponent(n);
                if (component != null && JComponent.isLightweightComponent(component) && component.isVisible()) {
                    Rectangle rectangle;
                    boolean bl2 = component instanceof JComponent;
                    if (bl2) {
                        if (this.tmpRect == null) {
                            this.tmpRect = new Rectangle();
                        }
                        rectangle = this.tmpRect;
                        ((JComponent)component).getBounds(rectangle);
                    } else {
                        rectangle = component.getBounds();
                    }
                    if (swingGraphics.isClipIntersecting(rectangle)) {
                        Object var13_11;
                        boolean bl3;
                        Graphics graphics2;
                        block19: {
                            graphics2 = SwingGraphics.createGraphics(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            bl3 = false;
                            try {
                                if (bl2) {
                                    if (this.getFlag(2)) {
                                        ((JComponent)component).setFlag(2, true);
                                        bl3 = true;
                                    }
                                    if (this.getFlag(3)) {
                                        ((JComponent)component).setFlag(3, true);
                                        bl3 = true;
                                    }
                                    ((JComponent)component).paint(graphics2);
                                    break block19;
                                }
                                component.paint(graphics2);
                            }
                            catch (Throwable throwable) {
                                var13_11 = null;
                                graphics2.dispose();
                                if (bl3) {
                                    ((JComponent)component).setFlag(2, false);
                                    ((JComponent)component).setFlag(3, false);
                                }
                                throw throwable;
                            }
                        }
                        var13_11 = null;
                        graphics2.dispose();
                        if (bl3) {
                            ((JComponent)component).setFlag(2, false);
                            ((JComponent)component).setFlag(3, false);
                        }
                    }
                }
                --n;
            }
        }
        if (bl) {
            swingGraphics.recycle();
        }
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        boolean bl = false;
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Graphics graphics2 = this.getComponentGraphics(graphics);
        boolean bl2 = !(graphics2 instanceof SwingGraphics);
        SwingGraphics swingGraphics = SwingGraphics.createSwingGraphics(graphics2);
        Image image = null;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        int n = swingGraphics.getClipX();
        int n2 = swingGraphics.getClipY();
        int n3 = swingGraphics.getClipWidth();
        int n4 = swingGraphics.getClipHeight();
        if (n3 > this.getWidth()) {
            n3 = this.getWidth();
        }
        if (n4 > this.getHeight()) {
            n4 = this.getHeight();
        }
        if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
            this.adjustPaintFlags();
            bl = true;
        }
        if (repaintManager.isDoubleBufferingEnabled() && !this.getFlag(2) && this.isDoubleBuffered()) {
            image = repaintManager.getOffscreenBuffer(this, n3, n4);
            if (bl2) {
                swingGraphics.recycle();
                bl2 = false;
            }
            swingGraphics = SwingGraphics.createSwingGraphics(image.getGraphics());
            swingGraphics.translate(-n, -n2);
            int n5 = image.getWidth(null);
            int n6 = image.getHeight(null);
            if (n5 > n3) {
                n5 = n3;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            try {
                this.setFlag(2, true);
                this.setFlag(3, true);
                int n7 = 0;
                int n8 = n3;
                while (n7 < n8) {
                    int n9 = 0;
                    int n10 = n4;
                    while (n9 < n10) {
                        if (n9 + n6 >= n10 && n7 + n5 >= n8) {
                            this.setFlag(3, false);
                        }
                        swingGraphics.translate(-n7, -n9);
                        swingGraphics.setClip(n + n7, n2 + n9, n5, n6);
                        if (!this.rectangleIsObscured(n, n2, n5, n6)) {
                            this.paintComponent(swingGraphics);
                            this.paintBorder(swingGraphics);
                        }
                        this.paintChildren(swingGraphics);
                        graphics.drawImage(image, n + n7, n2 + n9, this);
                        swingGraphics.translate(n7, n9);
                        n9 += n6;
                    }
                    n7 += n5;
                }
            }
            finally {
                Object var19_18 = null;
                this.setFlag(2, false);
                this.setFlag(3, false);
                swingGraphics.dispose();
            }
        } else {
            if (!this.rectangleIsObscured(n, n2, n3, n4)) {
                this.paintComponent(swingGraphics);
                this.paintBorder(swingGraphics);
            }
            this.paintChildren(swingGraphics);
        }
        if (bl2) {
            swingGraphics.recycle();
        }
        if (bl) {
            this.setFlag(2, false);
            this.setFlag(3, false);
        }
    }

    private void adjustPaintFlags() {
        JComponent jComponent = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JComponent) {
                jComponent = (JComponent)container;
                if (jComponent.getFlag(2)) {
                    this.setFlag(2, true);
                }
                if (!jComponent.getFlag(3)) break;
                this.setFlag(3, true);
                return;
            }
            container = container.getParent();
        }
    }

    public boolean isPaintingTile() {
        return this.getFlag(3);
    }

    public boolean isFocusCycleRoot() {
        return false;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public void setNextFocusableComponent(Component component) {
        this.putClientProperty(NEXT_FOCUS, component);
    }

    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.setFlag(0, !bl);
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(0);
    }

    public void requestFocus() {
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    public void grabFocus() {
        super.requestFocus();
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        if (dimension != null) {
            return dimension;
        }
        return super.getPreferredSize();
    }

    public void setMaximumSize(Dimension dimension) {
        this.maximumSize = dimension;
    }

    public Dimension getMaximumSize() {
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        if (dimension != null) {
            return dimension;
        }
        return super.getMaximumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumSize = dimension;
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        if (dimension != null) {
            return dimension;
        }
        return super.getMinimumSize();
    }

    public boolean contains(int n, int n2) {
        if (this.ui != null) {
            return this.ui.contains(this, n, n2);
        }
        return super.contains(n, n2);
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        this.invalidate();
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public float getAlignmentY() {
        if (this.alignmentY != null) {
            return this.alignmentY.floatValue();
        }
        return super.getAlignmentY();
    }

    public void setAlignmentY(float f) {
        this.alignmentY = new Float(f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f));
    }

    public float getAlignmentX() {
        if (this.alignmentX != null) {
            return this.alignmentX.floatValue();
        }
        return super.getAlignmentX();
    }

    public void setAlignmentX(float f) {
        this.alignmentX = new Float(f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f));
    }

    public Graphics getGraphics() {
        if (this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return SwingGraphics.createSwingGraphics(super.getGraphics());
    }

    public void setDebugGraphicsOptions(int n) {
        DebugGraphics.setDebugOptions(this, n);
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        Hashtable<KeyStroke, KeyboardBinding> hashtable;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            hashtable = (Hashtable<KeyStroke, KeyboardBinding>)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
            if (hashtable == null) {
                hashtable = new Hashtable<KeyStroke, KeyboardBinding>();
                this.putClientProperty(KEYBOARD_BINDINGS_KEY, hashtable);
                bl = true;
            }
        }
        serializable = hashtable;
        synchronized (serializable) {
            hashtable.put(keyStroke, new KeyboardBinding(actionListener, string, keyStroke, n));
        }
        if (bl) {
            this.enableEvents(8L);
        }
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    private Hashtable keyboardBindings() {
        Hashtable hashtable;
        JComponent jComponent = this;
        synchronized (jComponent) {
            hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        }
        return hashtable;
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            hashtable.remove(keyStroke);
        }
        hashtable.size();
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        KeyStroke[] keyStrokeArray;
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return new KeyStroke[0];
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            keyStrokeArray = new KeyStroke[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
        }
        return keyStrokeArray;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return -1;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke);
            if (keyboardBinding != null) {
                int n = keyboardBinding.getCondition();
                Object var5_6 = null;
                return n;
            }
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        Hashtable hashtable = this.keyboardBindings();
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke);
            if (keyboardBinding != null) {
                ActionListener actionListener = keyboardBinding.getAction();
                Object var5_6 = null;
                return actionListener;
            }
        }
        return null;
    }

    public void resetKeyboardActions() {
        JComponent jComponent = this;
        synchronized (jComponent) {
            Hashtable hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
            if (hashtable != null) {
                hashtable.clear();
            }
            return;
        }
    }

    public boolean requestDefaultFocus() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].isFocusTraversable()) {
                if (componentArray[n] instanceof JComponent) {
                    ((JComponent)componentArray[n]).grabFocus();
                } else {
                    componentArray[n].requestFocus();
                }
                return true;
            }
            if (componentArray[n] instanceof JComponent && !((JComponent)componentArray[n]).isManagingFocus() && ((JComponent)componentArray[n]).requestDefaultFocus()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public boolean isFocusTraversable() {
        Hashtable hashtable;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        }
        if (hashtable != null) {
            serializable = hashtable;
            synchronized (serializable) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    KeyboardBinding keyboardBinding = (KeyboardBinding)hashtable.get(enumeration.nextElement());
                    if (keyboardBinding.getCondition() != 0) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                this.setFlag(4, true);
                break;
            }
            case 1005: {
                this.setFlag(4, false);
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = false;
        if (FocusManager.isFocusManagerEnabled()) {
            FocusManager focusManager = FocusManager.getCurrentManager();
            focusManager.processKeyEvent(this, keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        if (keyEvent.getID() == 401) {
            bl2 = true;
            if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                KeyboardState.registerKeyPressed(keyEvent.getKeyCode());
            }
        } else if (keyEvent.getID() == 402) {
            if (KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                bl2 = true;
                KeyboardState.registerKeyReleased(keyEvent.getKeyCode());
            }
        } else if (keyEvent.getID() == 400) {
            bl2 = true;
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl2 && keyEvent.getID() == 401) {
            boolean bl3 = this.processKeyBindings(keyEvent, true);
            if (bl3) {
                keyEvent.consume();
                return;
            }
        } else if (bl2 && keyEvent.getID() == 402) {
            boolean bl4 = this.processKeyBindings(keyEvent, false);
            if (bl4) {
                keyEvent.consume();
                return;
            }
        } else if (bl2 && keyEvent.getID() == 400 && (bl = this.processKeyBindings(keyEvent, false))) {
            keyEvent.consume();
        }
    }

    KeyboardBinding bindingForKeyStroke(KeyStroke keyStroke, int n) {
        KeyboardBinding keyboardBinding;
        KeyboardBinding keyboardBinding2 = null;
        Hashtable hashtable = (Hashtable)this.getClientProperty(KEYBOARD_BINDINGS_KEY);
        if (hashtable != null && (keyboardBinding = (KeyboardBinding)hashtable.get(keyStroke)) != null) {
            ActionListener actionListener = keyboardBinding.getAction();
            if (actionListener instanceof Action && !((Action)actionListener).isEnabled()) {
                actionListener = null;
            }
            if (actionListener != null) {
                switch (keyboardBinding.getCondition()) {
                    case 0: {
                        if (n != 0) break;
                        keyboardBinding2 = keyboardBinding;
                        break;
                    }
                    case 1: {
                        if (n != 0 && n != 1) break;
                        keyboardBinding2 = keyboardBinding;
                        break;
                    }
                    case 2: {
                        if (n != 0 && n != 2 && n != 1) break;
                        keyboardBinding2 = keyboardBinding;
                        break;
                    }
                }
            }
        }
        return keyboardBinding2;
    }

    boolean processKeyBinding(KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = !bl;
        KeyboardBinding keyboardBinding = null;
        if (this.isEnabled()) {
            ActionListener actionListener;
            if (keyEvent.getID() == 400) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyChar());
                keyboardBinding = this.bindingForKeyStroke(keyStroke, n);
            } else {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), bl2);
                keyboardBinding = this.bindingForKeyStroke(keyStroke, n);
            }
            if (keyboardBinding != null && (actionListener = keyboardBinding.getAction()) != null) {
                actionListener.actionPerformed(new ActionEvent(this, 1001, keyboardBinding.getCommand()));
                return true;
            }
        }
        return false;
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl) {
        Vector<Container> vector = new Vector<Container>();
        if (this.processKeyBinding(keyEvent, 0, bl)) {
            return true;
        }
        vector.addElement(this);
        Container container = this.getParent();
        while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
            if (container instanceof JComponent) {
                if (((JComponent)container).processKeyBinding(keyEvent, 1, bl)) {
                    return true;
                }
                vector.addElement(container);
            }
            container = container.getParent();
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, vector, bl);
        }
        return false;
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, Vector vector, boolean bl) {
        if (!container.isVisible() || !container.isEnabled()) {
            return false;
        }
        if (container instanceof JComponent && !vector.contains(container) && ((JComponent)container).processKeyBinding(keyEvent, 2, bl)) {
            return true;
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n].isVisible() && componentArray[n].isEnabled() && componentArray[n] instanceof Container && JComponent.processKeyBindingsForAllComponents(keyEvent, (Container)componentArray[n], vector, bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setToolTipText(String string) {
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            toolTipManager.registerComponent(this);
            return;
        }
        toolTipManager.unregisterComponent(this);
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        int n = this.getX();
        int n2 = this.getY();
        Container container = this.getParent();
        while (container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane)) {
            Rectangle rectangle2 = container.getBounds();
            n += rectangle2.x;
            n2 += rectangle2.y;
            container = container.getParent();
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n;
            rectangle.y += n2;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n;
            rectangle.y -= n2;
        }
    }

    public void setAutoscrolls(boolean bl) {
        if (bl) {
            if (this.autoscroller == null) {
                this.autoscroller = new Autoscroller(this);
                return;
            }
        } else if (this.autoscroller != null) {
            this.autoscroller.stop();
            this.autoscroller = null;
        }
    }

    public boolean getAutoscrolls() {
        return this.autoscroller != null;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl = true;
        if (this.autoscroller != null && mouseEvent.getID() == 506) {
            bl = !this.autoscroller.timer.isRunning();
            this.autoscroller.mouseDragged(mouseEvent);
        }
        if (bl) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    private Dictionary getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        Object v = this.getClientProperties().get(object);
        if (object2 != null) {
            this.getClientProperties().put(object, object2);
        } else {
            this.getClientProperties().remove(object);
        }
        this.firePropertyChange(object.toString(), v, object2);
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            if (this._bounds.x + this._bounds.width > n && this._bounds.y + this._bounds.height > n2 && this._bounds.x < n + n3 && this._bounds.y < n2 + n4) {
                Rectangle[] rectangleArray = SwingUtilities.computeDifference(this.getBounds(), new Rectangle(n, n2, n3, n4));
                Container container = this.getParent();
                int n5 = 0;
                int n6 = rectangleArray.length;
                while (n5 < n6) {
                    container.repaint(rectangleArray[n5].x, rectangleArray[n5].y, rectangleArray[n5].width, rectangleArray[n5].height);
                    ++n5;
                }
            } else {
                this.getParent().repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            }
        }
        this._bounds.setBounds(n, n2, n3, n4);
        super.reshape(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this._bounds.setBounds(rectangle);
        super.setBounds(rectangle);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public int getX() {
        return this._bounds.x;
    }

    public int getY() {
        return this._bounds.y;
    }

    public int getWidth() {
        return this._bounds.width;
    }

    public int getHeight() {
        return this._bounds.height;
    }

    public boolean hasFocus() {
        return this.getFlag(4);
    }

    public boolean isOpaque() {
        return this.getFlag(5);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.getFlag(5);
        this.setFlag(5, bl);
        this.firePropertyChange("opaque", bl2, bl);
    }

    boolean rectangleIsObscured(int n, int n2, int n3, int n4) {
        Component[] componentArray = this.getComponents();
        if (componentArray == null) {
            return false;
        }
        int n5 = 0;
        while (n5 < componentArray.length) {
            Component component = componentArray[n5];
            Rectangle rectangle = component instanceof JComponent ? ((JComponent)component)._bounds : component.getBounds();
            if (n >= rectangle.x && n + n3 <= rectangle.x + rectangle.width && n2 >= rectangle.y && n2 + n4 <= rectangle.y + rectangle.height) {
                if (component instanceof JComponent) {
                    return ((JComponent)component).isOpaque();
                }
                return false;
            }
            ++n5;
        }
        return false;
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
            return;
        }
        JComponent.computeVisibleRect(container, rectangle);
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport != null && by != by2) {
            this.changeSupport.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public void firePropertyChange(String string, char c, char c2) {
        if (this.changeSupport != null && c != c2) {
            this.changeSupport.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public void firePropertyChange(String string, short s, short s2) {
        if (this.changeSupport != null && s != s2) {
            this.changeSupport.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (this.changeSupport != null && n != n2) {
            this.changeSupport.firePropertyChange(string, new Integer(n), new Integer(n2));
        }
    }

    public void firePropertyChange(String string, long l, long l2) {
        if (this.changeSupport != null && l != l2) {
            this.changeSupport.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public void firePropertyChange(String string, float f, float f2) {
        if (this.changeSupport != null && f != f2) {
            this.changeSupport.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public void firePropertyChange(String string, double d, double d2) {
        if (this.changeSupport != null && d != d2) {
            this.changeSupport.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null && bl != bl2) {
            this.changeSupport.firePropertyChange(string, new Boolean(bl), new Boolean(bl2));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public Container getTopLevelAncestor() {
        Container container = this;
        while (container != null) {
            if (container instanceof Window || container instanceof Applet) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            this.ancestorNotifier = new AncestorNotifier(this);
        }
        this.ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            return;
        }
        this.ancestorNotifier.removeAncestorListener(ancestorListener);
        if (this.ancestorNotifier.listenerList.getListenerList().length == 0) {
            this.ancestorNotifier.removeAllListeners();
            this.ancestorNotifier = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
    }

    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void revalidate() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
            return;
        }
        1 var1_1 = new 1();
        SwingUtilities.invokeLater(var1_1);
    }

    public boolean isValidateRoot() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void paintImmediately(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 /* !! */  = this;
        if (this.isShowing()) ** GOTO lbl10
        return;
        while ((var6_6 = var5_5 /* !! */ .getParent()) != null) {
            var7_7 = var5_5 /* !! */  instanceof JComponent != false ? var5_5 /* !! */ ._bounds : var5_5 /* !! */ .getBounds();
            var1_1 += var7_7.x;
            var2_2 += var7_7.y;
            var5_5 /* !! */  = var6_6;
            if (!(var5_5 /* !! */  instanceof JComponent)) break;
lbl10:
            // 2 sources

            if (!var5_5 /* !! */ .isOpaque()) continue;
        }
        if (var5_5 /* !! */  instanceof JComponent) {
            var5_5 /* !! */ ._paintImmediately(var1_1, var2_2, var3_3, var4_4);
            return;
        }
        var5_5 /* !! */ .repaint(var1_1, var2_2, var3_3, var4_4);
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void _paintImmediately(int n, int n2, int n3, int n4) {
        SwingGraphics swingGraphics;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.tmpRect == null) {
            this.tmpRect = new Rectangle();
        }
        this.tmpRect.y = 0;
        this.tmpRect.x = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        JComponent jComponent = null;
        JComponent jComponent2 = this;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Container container = this;
        while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
            if (container instanceof JComponent && !container.isOptimizedDrawingEnabled()) {
                jComponent2 = container;
                n6 = 0;
                n5 = 0;
                bl = false;
            }
            if (repaintManager.isDoubleBufferingEnabled() && container instanceof JComponent && container.isDoubleBuffered()) {
                bl = true;
                jComponent = container;
                n7 = n5;
                n8 = n6;
            }
            Rectangle rectangle2 = container instanceof JComponent ? container._bounds : container.getBounds();
            this.tmpRect.width = rectangle2.width;
            this.tmpRect.height = rectangle2.height;
            SwingUtilities.computeIntersection(this.tmpRect.x, this.tmpRect.y, this.tmpRect.width, this.tmpRect.height, rectangle);
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            n5 += rectangle2.x;
            n6 += rectangle2.y;
            container = container.getParent();
        }
        if (container == null || container.getPeer() == null) {
            return;
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        try {
            swingGraphics = SwingGraphics.createSwingGraphics(jComponent2.getGraphics());
        }
        catch (NullPointerException nullPointerException) {
            swingGraphics = null;
            nullPointerException.printStackTrace();
        }
        if (swingGraphics == null) {
            System.err.println("In paintImmediately null graphics");
            return;
        }
        if (bl) {
            Image image = repaintManager.getOffscreenBuffer(jComponent, rectangle.width, rectangle.height);
            this.paintWithBuffer(jComponent2, swingGraphics, rectangle, image);
            ((Graphics)swingGraphics).dispose();
            return;
        }
        ((Graphics)swingGraphics).setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            jComponent2.paint(swingGraphics);
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            ((Graphics)swingGraphics).dispose();
            throw throwable;
        }
        Object var18_20 = null;
        ((Graphics)swingGraphics).dispose();
    }

    private void paintWithBuffer(JComponent jComponent, Graphics graphics, Rectangle rectangle, Image image) {
        SwingGraphics swingGraphics = SwingGraphics.createSwingGraphics(image.getGraphics());
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n > rectangle.width) {
            n = rectangle.width;
        }
        if (n2 > rectangle.height) {
            n2 = rectangle.height;
        }
        try {
            jComponent.setFlag(2, true);
            jComponent.setFlag(3, true);
            int n3 = rectangle.x;
            int n4 = rectangle.x + rectangle.width;
            while (n3 < n4) {
                int n5 = rectangle.y;
                int n6 = rectangle.y + rectangle.height;
                while (n5 < n6) {
                    if (n5 + n2 >= n6 && n3 + n >= n4) {
                        jComponent.setFlag(3, false);
                    }
                    ((Graphics)swingGraphics).translate(-n3, -n5);
                    ((Graphics)swingGraphics).setClip(n3, n5, n, n2);
                    jComponent.paint(swingGraphics);
                    graphics.setClip(n3, n5, n, n2);
                    graphics.drawImage(image, n3, n5, jComponent);
                    ((Graphics)swingGraphics).translate(n3, n5);
                    n5 += n2;
                }
                n3 += n;
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            jComponent.setFlag(2, false);
            jComponent.setFlag(3, false);
            ((Graphics)swingGraphics).dispose();
            throw throwable;
        }
        Object var13_12 = null;
        jComponent.setFlag(2, false);
        jComponent.setFlag(3, false);
        ((Graphics)swingGraphics).dispose();
    }

    private void setFlag(int n, boolean bl) {
        if (bl) {
            this.flags |= 1 << n;
            return;
        }
        this.flags &= ~(1 << n);
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    public void setDoubleBuffered(boolean bl) {
        this.setFlag(1, bl);
    }

    public boolean isDoubleBuffered() {
        return this.getFlag(1);
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class KeyboardBinding
    implements Serializable {
        ActionListener action;
        String command;
        KeyStroke keyStroke;
        int condition;

        KeyboardBinding(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
            this.action = actionListener;
            this.command = string;
            this.keyStroke = keyStroke;
            this.condition = n;
        }

        ActionListener getAction() {
            return this.action;
        }

        String getCommand() {
            return this.command;
        }

        KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        int getCondition() {
            return this.condition;
        }

        public String toString() {
            return "KeyBinding (" + this.action + "," + this.keyStroke + "," + this.condition + ")";
        }
    }

    static final class IntVector {
        int[] array;
        int count;
        int capacity;

        int size() {
            return this.count;
        }

        int elementAt(int n) {
            return this.array[n];
        }

        void addElement(int n) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n;
        }

        void setElementAt(int n, int n2) {
            this.array[n2] = n;
        }

        IntVector() {
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = class$com$sun$java$swing$JComponent$KeyboardState != null ? class$com$sun$java$swing$JComponent$KeyboardState : (class$com$sun$java$swing$JComponent$KeyboardState = JComponent.class$("com.sun.java.swing.JComponent$KeyboardState"));

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }

        static void registerKeyPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (intVector.elementAt(n3) == -1) {
                    intVector.setElementAt(n, n3);
                    return;
                }
                ++n3;
            }
            intVector.addElement(n);
        }

        static void registerKeyReleased(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (intVector.elementAt(n3) == n) {
                    intVector.setElementAt(-1, n3);
                    return;
                }
                ++n3;
            }
        }

        static boolean keyIsPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (intVector.elementAt(n3) == n) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        KeyboardState() {
        }
    }

    public abstract class AccessibleJComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            Border border = JComponent.this.getBorder();
            if (border != null && border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            return null;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            try {
                String string = JComponent.this.getToolTipText(null);
                if (string != null) {
                    return string;
                }
            }
            catch (Exception exception) {}
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return SwingUtilities.getAccessibleStateSet(JComponent.this);
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = JComponent.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JComponent.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JComponent.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JComponent.this, n);
        }

        public Locale getLocale() {
            return JComponent.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return JComponent.this.getBackground();
        }

        public void setBackground(Color color) {
            JComponent.this.setBackground(color);
        }

        public Color getForeground() {
            return JComponent.this.getForeground();
        }

        public void setForeground(Color color) {
            JComponent.this.setForeground(color);
        }

        public Cursor getCursor() {
            return JComponent.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            JComponent.this.setCursor(cursor);
        }

        public Font getFont() {
            return JComponent.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)JComponent.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return JComponent.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return JComponent.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = JComponent.this.isEnabled();
            JComponent.this.setEnabled(bl);
            if (bl != bl2 && JComponent.this.accessibleContext != null) {
                if (bl) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
                    return;
                }
                JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }

        public boolean isVisible() {
            return JComponent.this.isVisible();
        }

        public void setVisible(boolean bl) {
            boolean bl2 = JComponent.this.isVisible();
            JComponent.this.setVisible(bl);
            if (bl != bl2 && JComponent.this.accessibleContext != null) {
                if (bl) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                    return;
                }
                JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }
        }

        public boolean isShowing() {
            return JComponent.this.isShowing();
        }

        public boolean contains(Point point) {
            return JComponent.this.contains(point);
        }

        public Point getLocationOnScreen() {
            if (JComponent.this.isShowing()) {
                return JComponent.this.getLocationOnScreen();
            }
            return null;
        }

        public Point getLocation() {
            return JComponent.this.getLocation();
        }

        public void setLocation(Point point) {
            JComponent.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return JComponent.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            JComponent.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return JComponent.this.getSize();
        }

        public void setSize(Dimension dimension) {
            JComponent.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JComponent.this, point);
        }

        public boolean isFocusTraversable() {
            return JComponent.this.isFocusTraversable();
        }

        public void requestFocus() {
            JComponent.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            JComponent.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            JComponent.this.removeFocusListener(focusListener);
        }

        public AccessibleJComponent() {
            JComponent.this = JComponent.this;
        }
    }

    private final class 1
    implements Runnable {
        public void run() {
            JComponent.this.revalidate();
        }

        /* synthetic */ 1() {
        }
    }
}

