/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;

class MyImage {
    ProgramCanvas parent;
    int imgIdH;
    double begT;
    double endT;
    int _xPix;
    int _yPix;
    Image rulerImg;
    int tx;
    public Color printLineColor;
    public Color normLineColor;
    public Color circleColor;
    public Color hiColor = Color.red;
    public Color normColor = Color.white;
    public int lrad = 1;
    public int brad = 3;
    public int angle = 40;
    public int ht = 20;
    public int max = 8;
    private int numDisp;
    private Display[] dispA;
    private Vector dtypeV;

    public MyImage(int n, int n2, int n3, Vector vector, ProgramCanvas programCanvas) {
        this.imgIdH = n;
        this._xPix = n2;
        this._yPix = n3;
        this.parent = programCanvas;
        this.dtypeV = vector;
        this.normLineColor = this.normColor;
        this.circleColor = this.hiColor;
        this.printLineColor = Color.black;
        this.setupDisps();
    }

    public MyImage(int n, int n2, Vector vector, ProgramCanvas programCanvas) {
        this._xPix = n;
        this._yPix = n2;
        this.parent = programCanvas;
        this.dtypeV = vector;
        this.numDisp = vector.size();
        this.normLineColor = this.normColor;
        this.circleColor = this.hiColor;
        this.printLineColor = Color.black;
    }

    void paintStuff1(int n, Graphics graphics, ImageObserver imageObserver) {
        graphics.drawImage(this.rulerImg, n, this.parent.allDispHt, imageObserver);
        int n2 = 0;
        while (n2 < this.numDisp) {
            graphics.drawImage(this.dispA[n2].img1, n, n2 * this.parent.eachDispHt, imageObserver);
            ++n2;
        }
    }

    void paintStuff2(int n, Graphics graphics, ImageObserver imageObserver) {
        graphics.drawImage(this.rulerImg, n, this.parent.allDispHt, imageObserver);
        int n2 = 0;
        while (n2 < this.numDisp) {
            if (this.dispA[n2].dtype == 0) {
                graphics.drawImage(this.dispA[n2].img2, n, n2 * this.parent.eachDispHt, imageObserver);
            } else {
                graphics.drawImage(this.dispA[n2].img1, n, n2 * this.parent.eachDispHt, imageObserver);
            }
            ++n2;
        }
    }

    private void setupDisps() {
        this.numDisp = this.dtypeV.size();
        this.rulerImg = this.parent.getOffScreenImage(this._xPix, this.parent.rulerHt);
        this.dispA = new Display[this.numDisp];
        int n = 0;
        while (n < this.numDisp) {
            int n2 = (Integer)this.dtypeV.elementAt(n);
            Image image = this.parent.getOffScreenImage(this._xPix, this.parent.eachDispHt);
            Image image2 = n2 == 0 ? this.parent.getOffScreenImage(this._xPix, this.parent.eachDispHt) : null;
            this.dispA[n] = new Display(n2, image, image2);
            ++n;
        }
    }

    void drawRegion(double d, double d2) {
        this.begT = d;
        this.endT = d2;
        this.drawStuff();
    }

    void setTimes(double d, double d2) {
        this.begT = d;
        this.endT = d2;
    }

    void drawStuff() {
        int n = 0;
        while (n < this.numDisp) {
            if (this.dispA[n].dtype == 0) {
                this.drawTimeLines(this.dispA[n]);
            } else {
                this.drawMtnRanges(this.dispA[n]);
            }
            ++n;
        }
        Graphics graphics = this.rulerImg.getGraphics();
        this.drawTimeRuler(graphics);
        graphics.dispose();
    }

    void printStuff(Graphics graphics) {
        int n = 0;
        while (n < this.numDisp) {
            if ((Integer)this.dtypeV.elementAt(n) == 0) {
                this.drawTimeLines(graphics);
            } else {
                this.drawMtnRanges(graphics);
            }
            graphics.translate(0, this.parent.eachDispHt);
            ++n;
        }
        this.drawTimeRuler(graphics);
    }

    private void drawTimeLines(Display display) {
        Graphics graphics = display.img1.getGraphics();
        Graphics graphics2 = display.img2.getGraphics();
        graphics.setColor(this.parent.parent.normImgBColor);
        graphics2.setColor(this.parent.parent.normImgBColor);
        graphics.fillRect(0, 0, this._xPix, this.parent.eachDispHt);
        graphics2.fillRect(0, 0, this._xPix, this.parent.eachDispHt);
        graphics.setColor(this.parent.parent.rulerColor);
        graphics2.setColor(this.parent.parent.rulerColor);
        graphics.fill3DRect(0, 0, this._xPix, this.parent.hBWt, true);
        graphics2.fill3DRect(0, 0, this._xPix, this.parent.hBWt, true);
        graphics.fill3DRect(0, this.parent.eachDispHt - this.parent.hBWt, this._xPix, this.parent.hBWt, true);
        graphics2.fill3DRect(0, this.parent.eachDispHt - this.parent.hBWt, this._xPix, this.parent.hBWt, true);
        this.drawStates(graphics, graphics2);
        this.drawArrows(graphics, graphics2);
        graphics.dispose();
        graphics2.dispose();
    }

    private void drawTimeLines(Graphics graphics) {
        graphics.setColor(this.parent.parent.printImgBColor);
        graphics.fillRect(0, 0, this._xPix, this.parent.eachDispHt);
        graphics.setColor(this.parent.parent.rulerColor);
        graphics.fill3DRect(0, 0, this._xPix, this.parent.hBWt, true);
        graphics.fill3DRect(0, this.parent.eachDispHt - this.parent.hBWt, this._xPix, this.parent.hBWt, true);
        this.drawStates(graphics, null);
        this.drawArrows(graphics, null);
    }

    private void drawMtnRanges(Display display) {
        Graphics graphics = display.img1.getGraphics();
        this.drawMtnRanges(graphics);
        graphics.dispose();
    }

    private void drawMtnRanges(Graphics graphics) {
        if (graphics instanceof PrintGraphics) {
            graphics.setColor(this.parent.parent.printImgBColor);
        } else {
            graphics.setColor(this.parent.parent.normImgBColor);
        }
        graphics.fillRect(0, 0, this._xPix, this.parent.eachDispHt);
        graphics.setColor(this.parent.parent.rulerColor);
        graphics.fill3DRect(0, 0, this._xPix, this.parent.hBWt, true);
        graphics.fill3DRect(0, this.parent.eachDispHt - this.parent.hBWt, this._xPix, this.parent.hBWt, true);
        this.drawMtns(graphics);
    }

    private void drawStates(Graphics graphics, Graphics graphics2) {
        Vector vector = this.parent.procVector;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            JProcess jProcess = (JProcess)enumeration.nextElement();
            if (!jProcess.dispStatus) continue;
            double d = this.parent.getProcYCord(this.parent.getIndex(this.parent.procVector, jProcess.procId));
            this.draw(jProcess, d, graphics, graphics2);
            Vector vector2 = jProcess.procStateVector;
            this.tx = -1;
            int n = vector2.size() - 1;
            while (n >= 0) {
                ProcessState processState = (ProcessState)vector2.elementAt(n);
                if (processState.info.stateDef.checkbox.isSelected() && !(processState.info.endT < this.begT) && !(processState.info.begT > this.endT)) {
                    if (processState.info.blink) {
                        this.parent.blink = true;
                    }
                    this.draw(processState, d, graphics, graphics2);
                }
                --n;
            }
        }
    }

    private void drawMtns(Graphics graphics) {
        Vector vector = this.parent.parent.mtns;
        Enumeration enumeration = vector.elements();
        this.tx = -1;
        while (enumeration.hasMoreElements()) {
            MtnInfo mtnInfo = (MtnInfo)enumeration.nextElement();
            if (mtnInfo.endT < this.begT || mtnInfo.begT > this.endT) continue;
            double d = this.endT - this.begT;
            double d2 = mtnInfo.begT - this.begT;
            double d3 = d2 > 0.0 ? d2 : 0.0;
            double d4 = mtnInfo.endT - this.begT > d ? d : mtnInfo.endT - this.begT;
            int n = this.parent.getW(d3, d4);
            int n2 = this.parent.getEvtXCord(d3);
            int n3 = this.parent.totalProc;
            int n4 = 0;
            while (n4 < mtnInfo.s.length) {
                CLOG_STATE cLOG_STATE = (CLOG_STATE)this.parent.parent.stateDefs.elementAt(n4);
                if (mtnInfo.s[n4] > 0 && cLOG_STATE.checkbox.isSelected()) {
                    if (n3 - mtnInfo.s[n4] < 0) break;
                    double d5 = (double)this.parent.hBWt + (double)this.parent.eachDispIHt / (double)this.parent.totalProc * (double)n3 - 1.0;
                    double d6 = (double)this.parent.hBWt + (double)this.parent.eachDispIHt / (double)this.parent.totalProc * (double)(n3 - mtnInfo.s[n4]);
                    double d7 = d5 - d6 + 1.0;
                    if (d7 == 0.0) {
                        d7 = 1.0;
                    }
                    double d8 = Math.rint(d6);
                    double d9 = d8 - d6;
                    int n5 = (int)d8;
                    int n6 = (int)Math.rint(d7 - d9);
                    if (n == 0) {
                        n = 1;
                    }
                    graphics.setColor(cLOG_STATE.color);
                    graphics.fillRect(n2, n5, n, n6);
                    n3 -= mtnInfo.s[n4];
                }
                ++n4;
            }
            this.tx = n2;
        }
    }

    private void drawArrows(Graphics graphics, Graphics graphics2) {
        if (!this.parent.arrowDispStatus) {
            return;
        }
        Enumeration enumeration = this.parent.parent.quiver.arrowVector.elements();
        while (enumeration.hasMoreElements()) {
            ArrowInfo arrowInfo = (ArrowInfo)enumeration.nextElement();
            if (!this.check(arrowInfo, this.begT, this.endT)) continue;
            this.draw(arrowInfo, graphics);
            if (arrowInfo.blink) {
                this.parent.blink = true;
            }
            if (graphics2 == null || arrowInfo.blink) continue;
            this.draw(arrowInfo, graphics2);
        }
    }

    private void draw(ProcessState processState, double d, Graphics graphics, Graphics graphics2) {
        int n;
        double d2 = processState.info.begT - this.begT;
        double d3 = d2 > 0.0 ? d2 : 0.0;
        double d4 = this.endT - this.begT;
        int n2 = this.parent.getW(d3, d4);
        int n3 = this.parent.getW(d3, processState.info.endT - this.begT);
        if (n3 > n2) {
            n3 = n2;
        }
        if ((n = this.parent.getEvtXCord(d3)) != this.tx || n3 != 0 && n3 != 1) {
            boolean bl = processState.info.begT >= this.begT;
            boolean bl2 = processState.info.endT <= this.endT;
            double d5 = (double)processState.info.level * this.parent.yDensity * this.parent.nestFactor;
            double d6 = this.parent.yDensity - d5;
            int n4 = (int)Math.rint(d - d6 / 2.0);
            int n5 = (int)Math.rint(d6);
            processState.y = n4;
            processState.h = n5;
            if (processState.h == 0) {
                processState.h = 1;
            }
            Color color = processState.info.stateDef.color;
            this.displayRect(graphics, color, n, n4, n3, n5, bl, bl2);
            if (graphics2 != null && !processState.info.blink) {
                this.displayRect(graphics2, color, n, n4, n3, n5, bl, bl2);
            }
        }
        this.tx = n;
    }

    private void displayRect(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        graphics.setColor(color);
        if (n3 == 0) {
            n3 = 1;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        if (bl) {
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
        }
        if (bl2) {
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
    }

    private void draw(JProcess jProcess, double d, Graphics graphics, Graphics graphics2) {
        int n;
        jProcess.y = n = (int)Math.rint(d);
        graphics.setColor(Color.red);
        graphics.drawLine(0, n, this._xPix - 1, n);
        if (graphics2 != null) {
            graphics2.setColor(Color.red);
            graphics2.drawLine(0, n, this._xPix - 1, n);
        }
    }

    private boolean check(ArrowInfo arrowInfo, double d, double d2) {
        if (arrowInfo.endT >= d && arrowInfo.begT <= d2) {
            int n = this.parent.getIndex(this.parent.procVector, arrowInfo.begProcId);
            int n2 = this.parent.getIndex(this.parent.procVector, arrowInfo.endProcId);
            int n3 = this.parent.procVector.size();
            if (n < n3 && n2 < n3 && ((JProcess)this.parent.procVector.elementAt((int)n)).dispStatus && ((JProcess)this.parent.procVector.elementAt((int)n2)).dispStatus) {
                return true;
            }
        }
        return false;
    }

    private void draw(ArrowInfo arrowInfo, Graphics graphics) {
        int n = this.parent.getEvtXCord(arrowInfo.begT - this.begT);
        int n2 = (int)Math.rint(this.parent.getProcYCord(this.parent.getIndex(this.parent.procVector, arrowInfo.begProcId)));
        int n3 = this.parent.getEvtXCord(arrowInfo.endT - this.begT);
        int n4 = (int)Math.rint(this.parent.getProcYCord(this.parent.getIndex(this.parent.procVector, arrowInfo.endProcId)));
        if (graphics instanceof PrintGraphics) {
            graphics.setColor(this.printLineColor);
        } else {
            graphics.setColor(this.normLineColor);
        }
        graphics.drawLine(n, n2, n3, n4);
        graphics.setColor(this.circleColor);
        graphics.fillOval(n - this.lrad, n2 - this.lrad, this.lrad * 2, this.lrad * 2);
        this.brad = (int)Math.rint(this.parent.yDensity / 2.0);
        if (this.brad > 10) {
            this.brad = 10;
        }
        if (this.brad < 3) {
            this.brad = 3;
        }
        graphics.drawOval(n - this.brad, n2 - this.brad, this.brad * 2, this.brad * 2);
        double d = Math.PI / 360 * (double)this.angle;
        double d2 = Math.abs(n3 - n);
        double d3 = Math.abs(n4 - n2);
        double d4 = Math.atan(d3 / d2);
        double d5 = 57.29577951308232;
        int n5 = 0;
        if (n2 < n4 && n3 > n) {
            n5 = (int)Math.rint(d5 * (Math.PI - d4 - d));
        } else if (n2 > n4 && n3 > n) {
            n5 = (int)Math.rint(d5 * (Math.PI + d4 - d));
        } else if (n2 > n4 && n > n3) {
            n5 = (int)Math.rint(d5 * (Math.PI * 2 - d4 - d));
        } else if (n4 > n2 && n > n3) {
            n5 = (int)Math.rint(d5 * (d4 - d));
        } else if (n2 == n4) {
            n5 = (int)Math.rint(d5 * (Math.PI - d));
            if (n > n3) {
                n5 += 180;
            }
        } else if (n == n3) {
            n5 = (int)Math.rint(d5 * (1.5707963267948966 - d));
            if (n2 > n4) {
                n5 += 180;
            }
        }
        if (graphics instanceof PrintGraphics) {
            graphics.setColor(this.printLineColor);
        } else {
            graphics.setColor(this.normLineColor);
        }
        this.ht = (int)Math.rint(this.parent.yDensity);
        if (this.ht > 20) {
            this.ht = 20;
        }
        graphics.fillArc(n3 - this.ht, n4 - this.ht, this.ht * 2, this.ht * 2, n5, this.angle);
    }

    private boolean check(double d, double d2, double d3) {
        return d >= d2 && d <= d3;
    }

    void drawTimeRuler(Graphics graphics) {
        graphics.setColor(this.parent.parent.rulerColor);
        graphics.fillRect(0, 0, this._xPix, this.parent.rulerHt);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, this._xPix, 0);
        double d = this.parent.getTime(this.parent.dpi);
        if (d <= 0.0) {
            return;
        }
        int n = (int)Math.rint(this.begT / d);
        double d2 = (double)n * d;
        while (d2 < this.endT && d2 < this.parent.maxT) {
            int n2;
            int n3 = n * this.parent.dpi - this.parent.getEvtXCord(this.begT);
            String string = new Float(d2).toString();
            String string2 = null;
            if (string.indexOf(69) == -1) {
                n2 = this.max;
                if (n2 > string.length()) {
                    n2 = string.length();
                }
                string2 = string.substring(0, n2);
            } else {
                n2 = string.indexOf(69);
                String string3 = string.substring(n2, string.length());
                int n4 = 5;
                if (n2 < n4) {
                    n4 = n2;
                }
                String string4 = string.substring(0, n4);
                string2 = String.valueOf(string4) + string3;
            }
            graphics.drawString("|", n3 - 2, this.parent.lineSize - this.parent.fDescent);
            graphics.drawString(string2, n3 - (int)Math.rint((double)this.parent.fm.stringWidth(string2) / 2.0), 2 * this.parent.lineSize - this.parent.fDescent);
            d2 = (double)(++n) * d;
        }
    }

    void kill() {
        int n = 0;
        while (n < this.dispA.length) {
            if (this.dispA[n].img1 != null) {
                this.dispA[n].img1.flush();
                this.dispA[n].img1 = null;
            }
            if (this.dispA[n].img2 != null) {
                this.dispA[n].img2.flush();
                this.dispA[n].img2 = null;
            }
            ++n;
        }
        if (this.rulerImg != null) {
            this.rulerImg.flush();
        }
        this.rulerImg = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

