<xsl:stylesheet xmlns:xsl="http://www.w3.org/XSL/Transform/1.0">

<xsl:template match="slides">
  <xsl:apply-templates select="slide"/>
</xsl:template>

<xsl:template match="slide">
  <xsl:call-template name="write">
    <xsl:with-param name="file" select="concat(@name,'.htm')"/>
    <xsl:with-param name="contents">
       <html>
          <head>
            <title><xsl:value-of select="@name"/></title>
          </head>
          <body>
             <xsl:apply-templates/>
             <xsl:if test="preceding-sibling::slide">
               <p><a href="{preceding-sibling::slide[1]/@name}.htm">Prev</a></p>
             </xsl:if>
             <xsl:if test="following-sibling::slide">
               <p><a href="{following-sibling::slide[1]/@name}.htm">Next</a></p>
             </xsl:if>
          </body>
       </html>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="write">
  <xsl:param name="contents"/>
  <xsl:param name="file"/>
  <xsl:value-of select="w:write($contents,string($file))"
     xmlns:w="http://www.jclark.com/xt/java/com.jclark.xsl.sax.HTMLFileWriter"
   />
</xsl:template>

<xsl:template match="*|@*">
  <xsl:copy>
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="node()"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
