/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef lslOpLIST_H
# define lslOpLIST_H

typedef /*@exposed@*/ lslOp e_lslOp;

abst_typedef struct _lslOpList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@only@*/ /*@relnull@*/ e_lslOp *elements;
} *lslOpList ;

extern /*@only@*/ lslOpList lslOpList_new(void);
extern void lslOpList_add (lslOpList p_s, /*@exposed@*/ lslOp p_el) ;

extern /*@unused@*/ /*@only@*/ cstring lslOpList_unparse (lslOpList p_s) ;
extern void lslOpList_free (/*@only@*/ lslOpList p_s) ;

/*@constant int lslOpListBASESIZE;@*/
# define lslOpListBASESIZE SMALLBASESIZE
# else
# error "Multiple include"
# endif




