/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	Ohio Trollius
 *
 *	$Id: tfgets.c,v 6.3 1999/08/27 22:35:38 jsquyres Exp $
 *
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

char *
tfgets(data, limit, fp)
	char *data;
	int limit;
	TFILE *fp;
{
	char *p = data;
	int c = 0;

	while((--limit > 0) && ((c = tfgetc(fp)) != EOF))
		if((*p++ = c) == '\n')
			break;
	*p = EOS;
	return((c == EOF && p == data) ? NULL : data);	/* NULL == EOF */
}

char *
tgets(data)
	char *data;
{
	char *p = data;
	int c;

	while(((c = tfgetc(tstdin)) != EOF) && (c != '\n')) {
		if(c == '\b') {
			if(p > data)
				--p;
		} else {
			*p++ = c;
		}
	}
	*p = EOS;
	return(((c == EOF) && (p == data)) ? NULL : data);  /* NULL == EOF */
}
