/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: dsend.c,v 6.3 1999/09/10 05:21:57 jsquyres Exp $
 *
 *	Function:	- sends a message at the datalink sublayer
 */

#include <net.h>

int
dsend(nhead)

struct nmsg		*nhead;

{
	struct kmsg	khead;		/* kernel message descriptor */	
	int4		mynodeid;
/*
 * Set up kernel message descriptor to send the network frame header.
 */
	khead.k_event = nhead->nh_dl_event;
	khead.k_length = nhead->nh_length;
/*
 * Categorize the message.
 * We must allow LOCAL to fall through before calling the router.
 */
	mynodeid = (nhead->nh_node == LOCAL) ? LOCAL : getnodeid();

	if ((nhead->nh_dl_event == nhead->nh_event) &&
			(nhead->nh_node == mynodeid)) {
		khead.k_type = nhead->nh_type;
		khead.k_flags = KNMSG | nhead->nh_flags;
	} else {
		khead.k_type = (nhead->nh_event >= 0) ? DLUSR : DLSYS;
		khead.k_flags = KNMSG | (nhead->nh_flags & (KTRY | KTRACE));

		if (nhead->nh_flags & DDLI) {
			khead.k_type |= DLI;
			nhead->nh_flags &= ~DDLI;
		}
	}

	khead.k_msg = (char *) nhead;

	return(ksend(&khead));
}

/*
 *	dtry_send
 *
 *	Function:	- non-blocking dsend()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
dtry_send(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = dsend(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
