/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wwait.c,v 1.1 1999/09/04 21:59:38 jsquyres Exp $
 *
 *	Function:	- one sided window wait
 *	Accepts:	- window
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>


int
MPI_Win_wait(win)

MPI_Win			win;

{
	MPI_Comm	comm;
	int		err;			/* error code */

	lam_initerr_m();
	lam_setfunc_m(BLKMPIWINWAIT);
/*
 * Check arguments.
 */
	if (win == MPI_WIN_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIWINWAIT, lam_mkerr(MPI_ERR_WIN, 0)));
	}

	comm = win->w_comm;

	if (!(win->w_flags & LAM_WFPOSTED)) {
		return(lam_errfunc(comm,
			BLKMPIWINWAIT, lam_mkerr(MPI_ERR_EPOCH, 0)));
	}
/*
 * Loop until everybody has completed.
 */
	_mpi_req_blkclr_m();
	_mpi_req_blkset_m(win->w_req);

	while (win->w_ncomplete > 0) {

		err = lam_osd_blkadv(win);
		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm, BLKMPIWINWAIT, err));
		}
	}
/*
 * Complete all remote one-sided requests in the window.
 */
	err = lam_osd_complete(win, LAM_RQFOSTARG);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIWINWAIT, err));
	}

	win->w_flags &= ~LAM_WFPOSTED;

        lam_resetfunc_m(BLKMPIWINWAIT);
	return(MPI_SUCCESS);
}
