/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tgetconts.c,v 1.0 1999/07/21 19:00:17 jsquyres Exp $
 *
 *	Function:	- get datatype contents
 *	Accepts:	- MPI datatype
 *			- number of integers
 *			- number of addresses
 *			- number of datatypes
 *			- array of integers (out)
 *			- array of addresses (out)
 *			- array of datatypes (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Type_get_contents(type, nints, naddrs, ndtypes, ints, addrs, dtypes)

MPI_Datatype		type;
int			nints;
int			naddrs;
int			ndtypes;
int			*ints;
MPI_Aint		*addrs;
MPI_Datatype		*dtypes;

{
	int		i;

	lam_initerr_m();
	lam_setfunc_m(BLKMPITGETCONT);
/*
 * Check arguments.
 */
	if (type == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITGETCONT,
					lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (dtypes == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITGETCONT,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (type->dt_flags & LAM_DTISDUP) {
	    dtypes[0] = (MPI_Datatype) type->dt_uargs;
	    dtypes[0]->dt_refcount++;
	}
	else if (type->dt_flags & LAM_DTISRESIZE) {
	    dtypes[0] = (MPI_Datatype) type->dt_uargs;
	    addrs[0] = type->dt_lower;
	    addrs[1] = type->dt_upper - type->dt_lower;
	    dtypes[0]->dt_refcount++;
	}
	else {
	    switch (type->dt_format) {

	    case LAM_DTBASIC:
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITGETCONT,
		    			lam_mkerr(MPI_ERR_TYPE, 0)));

	    case LAM_DTCONTIG:
		dtypes[0] = type->dt_dtype;
		ints[0] = type->dt_count;
		dtypes[0]->dt_refcount++;
		break;

	    case LAM_DTSTRUCT:
	    case LAM_DTSTRUCTCREAT:
		ints[0] = type->dt_count;
		for (i = 0; i < ints[0]; i++) {
		    ints[i + 1] = type->dt_lengths[i];
		    addrs[i] = type->dt_disps[i];
		    dtypes[i] = type->dt_dtypes[i];
		    dtypes[i]->dt_refcount++;
		}
		break;

	    case LAM_DTINDEXED:
		dtypes[0] = type->dt_dtype;
		dtypes[0]->dt_refcount++;
		ints[0] = type->dt_count;
		for (i = 0; i < ints[0]; i++) {
		    ints[i + 1] = type->dt_lengths[i];
		    ints[ints[0] + 1 + i] = (int) type->dt_disps[i];
		}
		break;

	    case LAM_DTHINDEXED:
	    case LAM_DTHINDEXEDCREAT:
		dtypes[0] = type->dt_dtype;
		ints[0] = type->dt_count;
		for (i = 0; i < ints[0]; i++) {
		    ints[i + 1] = type->dt_lengths[i];
		    addrs[i] = type->dt_disps[i];
		}
		break;

	    case LAM_DTVECTOR:
		dtypes[0] = type->dt_dtype;
		dtypes[0]->dt_refcount++;
		ints[0] = type->dt_count;
		ints[1] = type->dt_length;
		ints[2] = type->dt_stride;
		break;

	    case LAM_DTHVECTOR:
	    case LAM_DTHVECTORCREAT:
		dtypes[0] = type->dt_dtype;
		dtypes[0]->dt_refcount++;
		ints[0] = type->dt_count;
		ints[1] = type->dt_length;
		addrs[0] = type->dt_stride;
		break;

	    case LAM_DTSUBARRAY:
		dtypes[0] = type->dt_dtype;
		dtypes[0]->dt_refcount++;
		memcpy((char *) ints, (char *) type->dt_uargs, 
			(3 * type->dt_uargs[0] + 2) * sizeof(int));
		break;

	    case LAM_DTDARRAY:
		dtypes[0] = type->dt_dtype;
		dtypes[0]->dt_refcount++;
		memcpy((char *) ints, (char *) type->dt_uargs, 
			(4 * type->dt_uargs[2] + 4) * sizeof(int));
		break;

	    case LAM_DTINDEXEDBLK:
	    default:
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITGETCONT,
		    			lam_mkerr(MPI_ERR_TYPE, 0)));
	    }
	}

	lam_resetfunc_m(BLKMPITGETCONT);
	return(MPI_SUCCESS);
}
