/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: textent.c,v 6.2 1999/05/25 22:08:21 kmeyer1 Exp $
 *
 *	Function:	- return extent of datatype
 *	Accepts:	- datatype
 *			- ptr to extent (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Type_extent(dtype, pextent)

MPI_Datatype		dtype;
MPI_Aint		*pextent;

{
	lam_initerr();
	lam_setfunc(BLKMPITEXTENT);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITEXTENT, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (pextent == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITEXTENT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*pextent = dtype->dt_upper - dtype->dt_lower;
	}

	lam_resetfunc(BLKMPITEXTENT);
	return(MPI_SUCCESS);
}
