/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartmap.c,v 6.2 1999/05/25 22:07:45 kmeyer1 Exp $
 *
 *	Function:	- map processes to cartesian coordinates
 *	Accepts:	- communicator
 *			- # dimensions
 *			- # procs per dimension
 *			- dimension periodicity
 *			- caller's new rank (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cart_map(comm, ndims, dims, periods, newrank)

MPI_Comm		comm;
int			ndims;
int			*dims;
int			*periods;
int			*newrank;

{
	int		nprocs;
	int		rank;
	int		size;
	int		errcode;
	int		i;
	int		*p;

	lam_initerr();
	lam_setfunc(BLKMPICARTMAP);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (ndims < 1) {
		return(lam_errfunc(comm,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_DIMS, 0)));
	}

	if ((dims == 0) || (periods == 0) || (newrank == 0)) {
		return(lam_errfunc(comm,
			BLKMPICARTMAP, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Compute the # of processes in the grid.
 */
	nprocs = 1;
	for (i = 0, p = dims; i < ndims; ++i, ++p) {
		if (*p <= 0) {
			return(lam_errfunc(comm, BLKMPICARTMAP,
					lam_mkerr(MPI_ERR_DIMS, 0)));
		}

		nprocs *= *p;
	}
/*
 * Check that number of processes <= size of communicator.
 */
	errcode = MPI_Comm_size(comm, &size);
	if (errcode != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPICARTMAP, errcode));
	}

	if (nprocs > size) {
		return(lam_errfunc(comm, BLKMPICARTMAP,
					lam_mkerr(MPI_ERR_DIMS, 0)));
	}
/*
 * Compute my new rank.
 */
	errcode = MPI_Comm_rank(comm, &rank);
	if (errcode != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPICARTMAP, errcode));
	}

	*newrank = ((rank < 0) || (rank >= nprocs)) ? MPI_UNDEFINED : rank;

	lam_resetfunc(BLKMPICARTMAP);
	return(MPI_SUCCESS);
}
