/* 
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: getworkdir.c,v 6.3 1999/05/24 16:56:49 kmeyer1 Exp $
 * 
 *	Function:	- get the user's current working directory
 *			- dynamically allocated space
 *			- use old getwd() for efficiency if possible
 *			- hopefully our MAX is bigger than everybody's MAX
 *			  (someday a _real_ standard will emerge!)
 *	Returns:	- working directory or NULL
 */

#include "lam.h"

#include <stdlib.h>
#include <unistd.h>

#define PATHSIZE	2048


char *
getworkdir()

{
	char		*cwd;		/* working directory name */
/*
 * Allocate a hopefully large enough buffer;
 */
	if ((cwd = malloc((unsigned) PATHSIZE)) == 0) {
		return((char *) 0);
	}
/*
 * Get the working directory.  Work around SunOS bug.
 */
#if HAVE_GETCWD && !defined(SUNOS)
	if (getcwd(cwd, PATHSIZE)) {
#else
	if (getwd(cwd)) {
#endif
		return(cwd);
	} else {
		free(cwd);
		return((char *) 0);
	}
}
