/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: kattach.c,v 6.6 1999/07/28 00:31:46 jsquyres Exp $
 * 
 *	Function:	- attaches calling process to the kernel
 *	Accepts:	- process scheduling priority
 *	Returns:	- 0 or ERROR
 */
			  
#include <lam_config.h>

#include <signal.h>
#include <unistd.h>

#include <kio.h>
#include <kreq.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel I/O block */
extern int		errno;

/*
 * external functions
 */
extern int		_cio_kreq();		/* make kernel request */
extern void		_ksig_follow();		/* follow signals */

int
kattach(priority)

int			priority;

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */
	sigset_t	newset;		/* new signal set */
	sigset_t	oldset;		/* old signal set */

	LAM_ZERO_ME(req);
	LAM_ZERO_ME(reply);
	req.kq_req = KQATTACH;
	req.kq_index = _kio.ki_index;
	req.kq_pid = getpid();
	req.kq_priority = priority;
/*
 * Send the request to the kernel and receive a reply.
 */
	sigemptyset(&newset);
	sigaddset(&newset, LAM_SIGUSR);
	sigprocmask(SIG_BLOCK, &newset, &oldset);

	if (_cio_kreq(&req, &reply)) {
		sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);
		return(LAMERROR);
	}

	if (reply.kr_reply) {
		sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);
		errno = reply.kr_reply;
		return(LAMERROR);
	}

	_kio.ki_index = reply.kr_index;
	_kio.ki_rtf |= RTF_KERNEL;	
	_kio.ki_pid = getpid();	
	_kio.ki_priority = priority;
	sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);

	if (reply.kr_signal) {
		_kio.ki_signal |= reply.kr_signal;
		_ksig_follow();
	}

	return(0);
}
