/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : Prolog buit-in predicates                                       */
/* File  : consult_c.c                                                     */
/* Descr.: file consulting - C part                                        */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "engine_pl.h"
#include "bips_pl.h"

#ifdef M_ix86_cygwin
#include <process.h>
#endif




/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/




#if 1

/*-------------------------------------------------------------------------*/
/* CONSULT_2                                                               */
/*                                                                         */
/*-------------------------------------------------------------------------*/
Bool Consult_2(WamWord tmp_file_word,WamWord pl_file_word)

{
#ifdef __unix__

 char   *tmp_file,*pl_file;
 int     pid;
 int     pipe_out[2];
 FILE   *f_out;
 StmInf *pstm=stm_tbl+stm_top_level_output;
 int     status,c;
 char   *singl_warn;

 tmp_file=Rd_String_Check(tmp_file_word);
 pl_file =Rd_String_Check(pl_file_word);

 singl_warn=(Flag_Value(FLAG_SINGLETON_WARNING)) ? NULL : "--no-singl-warn";

 Os_Test_Error(pipe(pipe_out))

 Flush_All_Streams();
 pid=(int) fork();
 Os_Test_Error(pid== -1)
 
 if (pid==0)                                          /* the child process */
    {
     close(pipe_out[0]);
     if (pipe_out[1]!=1)
        {
         Os_Test_Error(dup2(pipe_out[1],1)== -1)
         Os_Test_Error(close(pipe_out[1]))
        }

     execlp("pl2wam","pl2wam","-w","--compile-msg","--no-redef-error","--pl-state",tmp_file,
                     "-o",tmp_file,pl_file,singl_warn,NULL);
     exit(63);                       /* only returns on error - quit child */
    }

 Os_Test_Error(close(pipe_out[1]))
 f_out=fdopen(pipe_out[0],"rt");
 Os_Test_Error(f_out==NULL)

 for(;;)
    {
     c=fgetc(f_out);
     if (c<0)
         break;

     Stream_Putc(c,pstm);
    }

 fclose(f_out);


 if (waitpid(pid,&status,0)<0 || !WIFEXITED(status))
     return FALSE;

 status=WEXITSTATUS(status);
 if (status==63)
     goto error_pl2wam;

 return status==0;

#else

#ifdef M_ix86_cygwin

 char *tmp_file,*pl_file;
 int   status;
 char *singl_warn;

 tmp_file=Rd_String_Check(tmp_file_word);
 pl_file =Rd_String_Check(pl_file_word);

 singl_warn=(Flag_Value(FLAG_SINGLETON_WARNING)) ? NULL : "--no-singl-warn";

 status=spawnlp(_P_WAIT,"pl2wam","pl2wam","-w","--compile-msg",
                "--no-redef-error","--pl-state",tmp_file,"-o",tmp_file,
                pl_file,singl_warn,NULL);
 if (status== -1)
     goto error_pl2wam;
 return status==0;

#else

 char *tmp_file,*pl_file;
 static
 char cmd[1024];

 tmp_file=Rd_String_Check(tmp_file_word);
 pl_file =Rd_String_Check(pl_file_word);

 sprintf(cmd,"pl2wam -w --compile-msg --pl-state %s -o %s %s %s",
         tmp_file,tmp_file,pl_file,
         (Flag_Value(FLAG_SINGLETON_WARNING)) ? "" : "--no-singl-warn");;

 return system(cmd)==0;
#endif /* M_ix86_cygwin */
#endif /* __unix__ */

error_pl2wam:
 Pl_Err_System(Create_Atom("error trying to execute pl2wam (maybe not found)"));
 return FALSE;

}

#endif
