.\" Copyright (c) 1993, 94, 95, 96, 1997 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution .in +0.9i
.TH nquery-pr 1 "May 1997" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
nquery-pr \- query problem reports over a network in the 
.B GNATS
database
.SH SYNOPSIS
.hy 0
.na
.B nquery\-pr
.RS
[
.B \-c \fIcategory\fB | \-\-category=\fIcategory\fB
]
.br
[
.B \-s \fIstate\fB | \-\-state=\fIstate\fB
]
.br
[
.B \-r \fIresponsible\fB | \-\-responsible=\fIresponsible\fB
]
.br
[
.B \-S \fIsubmitter\fB | \-\-submitter=\fIsubmitter\fB
]
.br
[
.B \-x | \-\-skip\-closed
]
.br
[
.B \-C [\fIyes\fB|\fIno\fB] | \-\-confidential[=\fIyes\fB|\fIno\fB]
]
.br
[
.B \-e \fIseverity\fB | \-\-severity=\fIseverity\fB
]
.br
[
.B \-p \fIpriority\fB | \-\-priority=\fIpriority\fB
]
.br
[
.B \-y \fIsynopsis\fB | \-\-synopsis=\fIsynopsis\fB
]
.br
[
.B \-L \fIclass\fB | \-\-class=\fIclass\fB
]
.br
[
.B \-A \fIrelease\fB | \-\-release=\fIrelease\fB
]
.br
[
.B \-O \fIname\fB | \-\-originator=\fIname\fB
]
.br
[
.B \-t \fItext\fP | \-\-text=\fItext\fP
]
.br
[
.B \-m \fItext\fP | \-\-multitext=\fItext\fP
]
.br
[
.B \-b \fIdate\fP | \-\-arrived\-before=\fIdate\fP
]
.br
[
.B \-a \fIdate\fP | \-\-arrived\-after=\fIdate\fP
]
.br
[
.B \-R | \-\-restricted
]
[
.B \-E | \-\-entire
]
.br
[
.B \-F | \-\-full
] [
.B \-q | \-\-summary
] [
.B \-i | \-\-sql
]
.br
[
.B \-d \fIdirectory\fB | \-\-directory=\fIdirectory\fB
]
.br
[
.B \-o \fIoutfile\fB | \-\-output=\fIoutfile\fB
]
.br
[
.B \-H \fIhostname\fB | \-\-host=\fIhostname\fB
]
.br
[
.B \-P \fIport\fB | \-\-port=\fIport\fB
]
.br
[
.B \-j | \-\-list\-categories
] [
.B \-k | \-\-list\-responsible
]
.br
[
.B \-l | \-\-list\-submitters
] [
.B \-P | \-\-print\-path
]
.br
[
.B \-V | \-\-version
]
[
.B \-h | \-\-help 
]
.br
[
.I gnats-id
.I .\|.\|.
]

.ad b
.hy 1
.SH DESCRIPTION
Queries the 
.B GNATS
database according to options and displays Problem Reports on standard output.
.B nquery\-pr
is nearly identical to 
.BR query\-pr ,
except it does queries to a network server, rather than looking for the
necessary files on the local disk.  The
.BI \-H \ hostname
user option, coupled with
.BI \-P \ port
are is the only key differences in terms of actual use.
.LP
All options are connected with a logical
.BR AND .
For example,
.RS
.B nquery\-pr \-\-category=\fIcategory\fB \-\-responsible=\fIresponsible\fR
.RE
only prints PRs which have a 
.B >Category:
field of
.I category
and a 
.B >Responsible:
field of
.IR responsible .
.SH OPTIONS
.TP 0.5i
.B \-c \fIcategory\fB, \-\-category=\fIcategory\fB
Search only for PRs with a
.B >Category:
field of 
.IR category .
.TP
.B \-s \fIstate\fB, \-\-state=\fIstate\fB
Search only for PRs with a
.B >State:
field of 
.IR state .
.TP
.B \-x, \-\-skip\-closed
Search only for PRs in states other than
.IR closed .
.TP
.B \-r \fIresponsible\fB, \-\-responsible=\fIresponsible\fB
Search only for PRs with a
.B >Responsible:
field of 
.IR responsible .
.TP
.B \-S \fIsubmitter\fB, \-\-submitter=\fIsubmitter\fB
Search only for PRs with a
.B >Submitter\-Id:
field of 
.IR submitter .
.TP
.B \-C [\fIyes\fB|\fIno\fB], \-\-confidential[=\fIyes\fB|\fIno\fB]
Search only for PRs with a 
.B >Confidential:
field of either
.I yes
or 
.IR no ,
respectively.  If this option is not given, all PRs will be eligible
for the search, regardless of their confidentiality.
.TP
.B \-e \fIseverity\fB, \-\-severity=\fIseverity\fB
Search only for PRs with a
.B >Severity:
field of
.IR severity .
.TP
.B \-p \fIpriority\fB, \-\-priority=\fIpriority\fB
Search only for PRs with a
.B >Priority:
field of
.IR priority .
.TP
.B \-y \fIsynopsis\fB, \-\-synopsis=\fIsynopsis\fB
Search only for PRs with a
.B >Synopsis:
field of
.IR synopsis .
.TP
.B \-L \fIclass\fB, \-\-class=\fIclass\fB
Search only for PRs with a
.B >Class:
field of
.IR class .
.TP
.B \-A \fIrelease\fB, \-\-release=\fIrelease\fB
Search only for PRs with a
.B >Release:
field of
.IR release .
.TP
.B \-O \fIname\fB, \-\-originator=\fIname\fP
Search for \fIname\fP in the
.B >Originator:
field of each PR.  \fIname\fP need only be enough to uniquely identify the
person.  For example, to find "Steve Williams" you could use a
\fIname\fP of "Steve W".
Use another search option (e.g.
.B \-\-state\c
\&), to speed the search.  Using
.B \-O
by itself can be slow with a large database.  You must enclose the
name with double-quotes to make sure your shell passes it as a single
string, and not as separate arguments to
.BR nquery\-pr .
.TP
.B \-t \fItext\fP, \-\-text=\fItext\fP
Search single-line text fields in all PRs for the regular 
expression \fItext\fP.
.TP
.B \-m \fItext\fP, \-\-multitext=\fItext\fP
Search multiple-line text fields in all PRs for the regular
expression \fItext\fP.
.PP
.B \-b \fIdate\fP, \-\-arrived\-before=\fIdate\fP
.TP
.B \-a \fIdate\fP, \-\-arrived\-after=\fIdate\fP
Find all PRs that came before or after a certain \fIdate\fP.
.TP
.B \-R, \-\-restricted
Omit from the search any PR marked
.BR ">Confidential: yes" .
This is equivalent to specifying
.BR \-\-confidential=no .
This also disallows the use of the options
.br
.BI --outfile= outfile
and
.BI --directory= directory\fR.
.TP
.B \-F, \-\-full
Prints the full Problem Report rather than just a summary.
.TP
.B \-q, \-\-summary
Give a short summary line for PRs. 
.TP
.B \-i, \-\-sql
Prints data in a format readable by a relational database (see
the GNATS manual
.I Keeping Track
for a full explanation).
.TP
.B \-H \fIhostname\fB, \-\-host=\fIhostname\fB
Directs
.B nquery\-pr
to connect to
.I hostname
instead of its default server.
.TP
.B \-P \fIport\fB, \-\-port=\fIport\fB
Directs
.B nquery\-pr
to use
.I port
instead of the default port value of 1529.
.TP
.B \-j, \-\-list-categories
Prints a list of all categories in the GNATS system.
.TP
.B \-k, \-\-list-responsible
Prints a list of all responsible names in the GNATS system.
.TP
.B \-l, \-\-list-submitters
Prints a list of all submitters in the GNATS system.
.TP
.B \-P, \-\-print\-path
Print the path used to find each PR.
.TP
.B \-d \fIdirectory\fB, \-\-directory=\fIdirectory\fB
Changes the search directory to 
.IR directory .
.TP
.B \-o \fIoutfile\fB, \-\-output=\fIoutfile\fB
Print all output to
.I outfile
rather than to the standard output.
.TP
.B \-V, \-\-version
Prints the version number of
.BR nquery\-pr .
.TP
.B \-h, \-\-help 
Prints a brief usage summary.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (l),
.BR send-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdist (8).
.SH COPYING
Copyright (c) 1993, 94, 95, 96, 1997 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
