/* $Header: /cvs/gnome/gIDE/src/gI_file.h,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_FILE_H
#define GI_FILE_H

#include <gtk/gtk.h>
#include "structs.h"

/*
 * Prototypes for 'gI_file.c'
 */
gchar *file_strip_name( gchar *filename );
void file_new( GtkWidget *widget, gpointer data );
void file_open( GtkWidget *widget, gpointer data );
void file_open_ok( GtkWidget *widget, GtkFileSelection *sel );
void file_open_by_name( gI_window *window, gchar *filename );
void file_open_cancel( GtkWidget *widget, GtkFileSelection *sel );
void file_reload( GtkWidget *widget, gpointer data );
void file_save( GtkWidget *widget, gpointer data );
void file_save_as( GtkWidget *widget, gpointer data );
void file_save_ok( GtkWidget *widget, GtkFileSelection *sel );
void file_save_by_name( gI_window *window, gchar *filename );
void file_save_cancel( GtkWidget *widget, GtkFileSelection *sel );
void file_print( GtkWidget *widget, gpointer data );
void file_close( GtkWidget *widget, gpointer data );
gint file_close_changed_dialog_modal( gI_document *document );
void file_exit( GtkWidget *widget, gpointer data );
void file_exit_is_changed( gI_window *window );
void file_exit_changed_dialog( gI_document *document );
void file_exit_changed_ok( GtkWidget *widget, gpointer data );
void file_exit_changed_cancel( GtkWidget *widget, gpointer data );
void file_autosave( GtkWidget *widget, gpointer data );
gint file_check_if_exist(gchar *,gint );
glong check_doc_changed( gI_document *doc );

#endif

