indexing
	description: "Gtk Eiffel Library command"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:37:42 $"
	revision: "$Revision: 1.1.1.1 $"

class
	GTK_CALLBACK_DATA

create
	make

feature -- Initialization

	make (a_source: GTK_ANY; a_signal: STRING; a_command: GTK_COMMAND; a_data: ANY) is
		require
			source_not_void: a_source /= Void
			signal_not_void: a_signal /= Void
			command_not_void: a_command /= Void
		do
			source := a_source
			signal := clone (a_signal)
			command := a_command
			data := a_data
		ensure
			source_assigned: source = a_source
			signal_assigned: signal.is_equal (a_signal)
			command_assigned: command = a_command
		end

feature -- Access

	source: GTK_ANY

	signal: STRING

	command: GTK_COMMAND

	callback_handle: INTEGER

	set_callback_handle (a_callback_handle: INTEGER) is
		do
			callback_handle := a_callback_handle
		ensure
			callback_handle_assigned: callback_handle = a_callback_handle
		end

	data: ANY

	set_data (a_data: ANY) is
		require
			data_not_void: a_data /= Void
		do
			data := a_data
		ensure
			data_assigned: data = a_data
		end

invariant
	source_not_void: source /= Void
	source_coupled: source.is_coupled
	signal_not_void: signal /= Void
	command_not_void: command /= Void

end -- class GTK_CALLBACK_DATA


--!-----------------------------------------------------------------------------
--! GEL, the GTK Eiffel Library
--! Copyright (C) 1999, Sam O'Connor, Sam@OConnor.net
--!
--! This library is free software; you can redistribute it and/or
--! modify it under the terms of the GNU Library General Public
--! License as published by the Free Software Foundation; either
--! version 2 of the License, or (at your option) any later version.
--!
--! This library is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--! Library General Public License for more details.
--!
--! You should have received a copy of the GNU Library General Public
--! License along with this library; if not, write to the Free
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!-----------------------------------------------------------------------------
