indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkCList"
	gtk_file: "gtkclist.h"
	status: "See notice at end of class"
	signals: "select_row unselect_row row_move click_column resize_column toggle_focus_row select_all unselect_all undo_selection start_selection end_selection toggle_add_mode extend_selection scroll_vertical scroll_horizontal abort_column_resize "
	events: ""

class
	C_GTK_CLIST

feature -- External C functions

	gtk_clist_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_clist_get_type (
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkType gtk_clist_get_type (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_construct (a_clist: POINTER; a_columns: INTEGER; a_titles: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_construct (
			--     GtkCList *a_clist,
			--     gint a_columns,
			--     gchar **a_titles
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_construct (GtkCList *clist,
			-- 			  gint      columns,
			-- 			  gchar    *titles[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_new (a_columns: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_clist_new (
			--     gint a_columns
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkWidget* gtk_clist_new             (gint   columns);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_new_with_titles (a_columns: INTEGER; a_titles: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_clist_new_with_titles (
			--     gint a_columns,
			--     gchar **a_titles
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkWidget* gtk_clist_new_with_titles (gint   columns,
			-- 				      gchar *titles[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_hadjustment (a_clist: POINTER; a_adjustment: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_hadjustment (
			--     GtkCList *a_clist,
			--     GtkAdjustment *a_adjustment
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_hadjustment (GtkCList      *clist,
			-- 				GtkAdjustment *adjustment);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_vadjustment (a_clist: POINTER; a_adjustment: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_vadjustment (
			--     GtkCList *a_clist,
			--     GtkAdjustment *a_adjustment
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_vadjustment (GtkCList      *clist,
			-- 				GtkAdjustment *adjustment);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_hadjustment (a_clist: POINTER): POINTER is 
			-- Parsed as:
			-- GtkAdjustment* gtk_clist_get_hadjustment (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkAdjustment* gtk_clist_get_hadjustment (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_vadjustment (a_clist: POINTER): POINTER is 
			-- Parsed as:
			-- GtkAdjustment* gtk_clist_get_vadjustment (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkAdjustment* gtk_clist_get_vadjustment (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_shadow_type (a_clist: POINTER; a_type: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_shadow_type (
			--     GtkCList *a_clist,
			--     GtkShadowType a_type
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_shadow_type (GtkCList      *clist,
			-- 				GtkShadowType  type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_selection_mode (a_clist: POINTER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_selection_mode (
			--     GtkCList *a_clist,
			--     GtkSelectionMode a_mode
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_selection_mode (GtkCList         *clist,
			-- 				   GtkSelectionMode  mode);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_reorderable (a_clist: POINTER; a_reorderable: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_reorderable (
			--     GtkCList *a_clist,
			--     gboolean a_reorderable
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_reorderable (GtkCList *clist,
			-- 				gboolean  reorderable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_use_drag_icons (a_clist: POINTER; a_use_icons: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_use_drag_icons (
			--     GtkCList *a_clist,
			--     gboolean a_use_icons
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_use_drag_icons (GtkCList *clist,
			-- 				   gboolean  use_icons);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_button_actions (a_clist: POINTER; a_button: INTEGER; a_button_actions: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_button_actions (
			--     GtkCList *a_clist,
			--     guint a_button,
			--     guint8 a_button_actions
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_button_actions (GtkCList *clist,
			-- 				   guint     button,
			-- 				   guint8    button_actions);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_freeze (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_freeze (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_freeze (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_thaw (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_thaw (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_thaw   (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_column_titles_show (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_column_titles_show (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_column_titles_show (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_column_titles_hide (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_column_titles_hide (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_column_titles_hide (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_column_title_active (a_clist: POINTER; a_column: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_column_title_active (
			--     GtkCList *a_clist,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_column_title_active   (GtkCList *clist,
			-- 				      gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_column_title_passive (a_clist: POINTER; a_column: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_column_title_passive (
			--     GtkCList *a_clist,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_column_title_passive  (GtkCList *clist,
			-- 				      gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_column_titles_active (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_column_titles_active (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_column_titles_active  (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_column_titles_passive (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_column_titles_passive (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_column_titles_passive (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_title (a_clist: POINTER; a_column: INTEGER; a_title: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_column_title (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gchar *a_title
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_title (GtkCList    *clist,
			-- 				 gint         column,
			-- 				 const gchar *title);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_column_title (a_clist: POINTER; a_column: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_clist_get_column_title (
			--     GtkCList *a_clist,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gchar * gtk_clist_get_column_title (GtkCList *clist,
			-- 				    gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_widget (a_clist: POINTER; a_column: INTEGER; a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_column_widget (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_widget (GtkCList  *clist,
			-- 				  gint       column,
			-- 				  GtkWidget *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_column_widget (a_clist: POINTER; a_column: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_clist_get_column_widget (
			--     GtkCList *a_clist,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkWidget * gtk_clist_get_column_widget (GtkCList *clist,
			-- 					 gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_justification (a_clist: POINTER; a_column: INTEGER; a_justification: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_column_justification (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     GtkJustification a_justification
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_justification (GtkCList         *clist,
			-- 					 gint              column,
			-- 					 GtkJustification  justification);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_visibility (a_clist: POINTER; a_column: INTEGER; a_visible: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_column_visibility (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gboolean a_visible
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_visibility (GtkCList *clist,
			-- 				      gint      column,
			-- 				      gboolean  visible);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_resizeable (a_clist: POINTER; a_column: INTEGER; a_resizeable: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_column_resizeable (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gboolean a_resizeable
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_resizeable (GtkCList *clist,
			-- 				      gint      column,
			-- 				      gboolean  resizeable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_auto_resize (a_clist: POINTER; a_column: INTEGER; a_auto_resize: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_column_auto_resize (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gboolean a_auto_resize
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_auto_resize (GtkCList *clist,
			-- 				       gint      column,
			-- 				       gboolean  auto_resize);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_columns_autosize (a_clist: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_columns_autosize (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_columns_autosize (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_optimal_column_width (a_clist: POINTER; a_column: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_optimal_column_width (
			--     GtkCList *a_clist,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_optimal_column_width (GtkCList *clist,
			-- 				     gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_width (a_clist: POINTER; a_column: INTEGER; a_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_column_width (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gint a_width
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_width (GtkCList *clist,
			-- 				 gint      column,
			-- 				 gint      width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_min_width (a_clist: POINTER; a_column: INTEGER; a_min_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_column_min_width (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gint a_min_width
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_min_width (GtkCList *clist,
			-- 				     gint      column,
			-- 				     gint      min_width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_column_max_width (a_clist: POINTER; a_column: INTEGER; a_max_width: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_column_max_width (
			--     GtkCList *a_clist,
			--     gint a_column,
			--     gint a_max_width
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_column_max_width (GtkCList *clist,
			-- 				     gint      column,
			-- 				     gint      max_width);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_row_height (a_clist: POINTER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_row_height (
			--     GtkCList *a_clist,
			--     guint a_height
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_row_height (GtkCList *clist,
			-- 			       guint     height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_moveto (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_row_align: REAL; a_col_align: REAL) is 
			-- Parsed as:
			-- void gtk_clist_moveto (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     gfloat a_row_align,
			--     gfloat a_col_align
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_moveto (GtkCList *clist,
			-- 		       gint      row,
			-- 		       gint      column,
			-- 		       gfloat    row_align,
			-- 		       gfloat    col_align);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_row_is_visible (a_clist: POINTER; a_row: INTEGER): INTEGER is 
			-- Parsed as:
			-- GtkVisibility gtk_clist_row_is_visible (
			--     GtkCList *a_clist,
			--     gint a_row
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkVisibility gtk_clist_row_is_visible (GtkCList *clist,
			-- 					gint      row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_cell_type (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER): INTEGER is 
			-- Parsed as:
			-- GtkCellType gtk_clist_get_cell_type (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkCellType gtk_clist_get_cell_type (GtkCList *clist,
			-- 				     gint      row,
			-- 				     gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_text (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_text: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_text (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     gchar *a_text
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_text (GtkCList    *clist,
			-- 			 gint         row,
			-- 			 gint         column,
			-- 			 const gchar *text);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_text (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_text: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_get_text (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     gchar **a_text
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_get_text (GtkCList  *clist,
			-- 			 gint       row,
			-- 			 gint       column,
			-- 			 gchar    **text);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_pixmap (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_pixmap: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_pixmap (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_pixmap (GtkCList  *clist,
			-- 			   gint       row,
			-- 			   gint       column,
			-- 			   GdkPixmap *pixmap,
			-- 			   GdkBitmap *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_pixmap (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_pixmap: POINTER; a_mask: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_get_pixmap (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     GdkPixmap **a_pixmap,
			--     GdkBitmap **a_mask
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_get_pixmap (GtkCList   *clist,
			-- 			   gint        row,
			-- 			   gint        column,
			-- 			   GdkPixmap **pixmap,
			-- 			   GdkBitmap **mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_pixtext (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_text: POINTER; a_spacing: INTEGER; a_pixmap: POINTER; a_mask: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_pixtext (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     gchar *a_text,
			--     guint8 a_spacing,
			--     GdkPixmap *a_pixmap,
			--     GdkBitmap *a_mask
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_pixtext (GtkCList    *clist,
			-- 			    gint         row,
			-- 			    gint         column,
			-- 			    const gchar *text,
			-- 			    guint8       spacing,
			-- 			    GdkPixmap   *pixmap,
			-- 			    GdkBitmap   *mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_pixtext (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_text: POINTER; a_spacing: POINTER; a_pixmap: POINTER; a_mask: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_get_pixtext (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     gchar **a_text,
			--     guint8 *a_spacing,
			--     GdkPixmap **a_pixmap,
			--     GdkBitmap **a_mask
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_get_pixtext (GtkCList   *clist,
			-- 			    gint        row,
			-- 			    gint        column,
			-- 			    gchar     **text,
			-- 			    guint8     *spacing,
			-- 			    GdkPixmap **pixmap,
			-- 			    GdkBitmap **mask);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_foreground (a_clist: POINTER; a_row: INTEGER; a_color: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_foreground (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_foreground (GtkCList *clist,
			-- 			       gint      row,
			-- 			       GdkColor *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_background (a_clist: POINTER; a_row: INTEGER; a_color: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_background (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     GdkColor *a_color
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_background (GtkCList *clist,
			-- 			       gint      row,
			-- 			       GdkColor *color);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_cell_style (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_cell_style (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_cell_style (GtkCList *clist,
			-- 			       gint      row,
			-- 			       gint      column,
			-- 			       GtkStyle *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_cell_style (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_clist_get_cell_style (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkStyle *gtk_clist_get_cell_style (GtkCList *clist,
			-- 				    gint      row,
			-- 				    gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_row_style (a_clist: POINTER; a_row: INTEGER; a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_row_style (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_row_style (GtkCList *clist,
			-- 			      gint      row,
			-- 			      GtkStyle *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_row_style (a_clist: POINTER; a_row: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_clist_get_row_style (
			--     GtkCList *a_clist,
			--     gint a_row
			-- );
			--
			-- Original C code from gtkclist.h:
			-- GtkStyle *gtk_clist_get_row_style (GtkCList *clist,
			-- 				   gint      row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_shift (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER; a_vertical: INTEGER; a_horizontal: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_shift (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column,
			--     gint a_vertical,
			--     gint a_horizontal
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_shift (GtkCList *clist,
			-- 			  gint      row,
			-- 			  gint      column,
			-- 			  gint      vertical,
			-- 			  gint      horizontal);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_selectable (a_clist: POINTER; a_row: INTEGER; a_selectable: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_selectable (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gboolean a_selectable
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_selectable (GtkCList *clist,
			-- 			       gint      row,
			-- 			       gboolean  selectable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_selectable (a_clist: POINTER; a_row: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_clist_get_selectable (
			--     GtkCList *a_clist,
			--     gint a_row
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gboolean gtk_clist_get_selectable (GtkCList *clist,
			-- 				   gint      row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_prepend (a_clist: POINTER; a_text: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_prepend (
			--     GtkCList *a_clist,
			--     gchar **a_text
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_prepend (GtkCList    *clist,
			-- 		        gchar       *text[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_append (a_clist: POINTER; a_text: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_append (
			--     GtkCList *a_clist,
			--     gchar **a_text
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_append  (GtkCList    *clist,
			-- 			gchar       *text[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_insert (a_clist: POINTER; a_row: INTEGER; a_text: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_insert (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gchar **a_text
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_insert (GtkCList    *clist,
			-- 		       gint         row,
			-- 		       gchar       *text[]);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_remove (a_clist: POINTER; a_row: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_remove (
			--     GtkCList *a_clist,
			--     gint a_row
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_remove (GtkCList *clist,
			-- 		       gint      row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_row_data (a_clist: POINTER; a_row: INTEGER; a_data: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_row_data (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_row_data (GtkCList *clist,
			-- 			     gint      row,
			-- 			     gpointer  data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_row_data_full (a_clist: POINTER; a_row: INTEGER; a_data: POINTER; a_destroy: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_row_data_full (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gpointer a_data,
			--     GtkDestroyNotify a_destroy
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_row_data_full (GtkCList         *clist,
			-- 			          gint              row,
			-- 			          gpointer          data,
			-- 				  GtkDestroyNotify  destroy);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_row_data (a_clist: POINTER; a_row: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_clist_get_row_data (
			--     GtkCList *a_clist,
			--     gint a_row
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gpointer gtk_clist_get_row_data (GtkCList *clist,
			-- 				 gint      row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_find_row_from_data (a_clist: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_find_row_from_data (
			--     GtkCList *a_clist,
			--     gpointer a_data
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_find_row_from_data (GtkCList *clist,
			-- 				   gpointer  data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_select_row (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_select_row (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_select_row (GtkCList *clist,
			-- 			   gint      row,
			-- 			   gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_unselect_row (a_clist: POINTER; a_row: INTEGER; a_column: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_unselect_row (
			--     GtkCList *a_clist,
			--     gint a_row,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_unselect_row (GtkCList *clist,
			-- 			     gint      row,
			-- 			     gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_undo_selection (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_undo_selection (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_undo_selection (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_clear (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_clear (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_clear (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_get_selection_info (a_clist: POINTER; a_x: INTEGER; a_y: INTEGER; a_row: POINTER; a_column: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_clist_get_selection_info (
			--     GtkCList *a_clist,
			--     gint a_x,
			--     gint a_y,
			--     gint *a_row,
			--     gint *a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- gint gtk_clist_get_selection_info (GtkCList *clist,
			-- 			     	   gint      x,
			-- 			     	   gint      y,
			-- 			     	   gint     *row,
			-- 			     	   gint     *column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_select_all (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_select_all (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_select_all (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_unselect_all (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_unselect_all (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_unselect_all (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_swap_rows (a_clist: POINTER; a_row1: INTEGER; a_row2: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_swap_rows (
			--     GtkCList *a_clist,
			--     gint a_row1,
			--     gint a_row2
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_swap_rows (GtkCList *clist,
			-- 			  gint      row1,
			-- 			  gint      row2);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_row_move (a_clist: POINTER; a_source_row: INTEGER; a_dest_row: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_row_move (
			--     GtkCList *a_clist,
			--     gint a_source_row,
			--     gint a_dest_row
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_row_move (GtkCList *clist,
			-- 			 gint      source_row,
			-- 			 gint      dest_row);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_compare_func (a_clist: POINTER; a_cmp_func: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_set_compare_func (
			--     GtkCList *a_clist,
			--     GtkCListCompareFunc a_cmp_func
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_compare_func (GtkCList            *clist,
			-- 				 GtkCListCompareFunc  cmp_func);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_sort_column (a_clist: POINTER; a_column: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_sort_column (
			--     GtkCList *a_clist,
			--     gint a_column
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_sort_column (GtkCList *clist,
			-- 				gint      column);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_sort_type (a_clist: POINTER; a_sort_type: INTEGER) is 
			-- Parsed as:
			-- void gtk_clist_set_sort_type (
			--     GtkCList *a_clist,
			--     GtkSortType a_sort_type
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_sort_type (GtkCList    *clist,
			-- 			      GtkSortType  sort_type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_sort (a_clist: POINTER) is 
			-- Parsed as:
			-- void gtk_clist_sort (
			--     GtkCList *a_clist
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_sort (GtkCList *clist);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_clist_set_auto_sort (a_clist: POINTER; a_auto_sort: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_clist_set_auto_sort (
			--     GtkCList *a_clist,
			--     gboolean a_auto_sort
			-- );
			--
			-- Original C code from gtkclist.h:
			-- void gtk_clist_set_auto_sort (GtkCList *clist,
			-- 			      gboolean  auto_sort);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_CLIST

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)