indexing
	description: "C function prototype"
	status: "see notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	C_PROTOTYPE

inherit
	C_ARGUMENT
		rename
			make as c_argument_make
		end

creation
	make,
	make_with_arguments

feature -- Initialization

	make (function: C_ARGUMENT) is
			-- Set prototype `type' `indir' and `name' from `function'
		require
			valid_function_argument: function /= Void
		do
			create arguments.make
			name := function.name
			type := function.type
			indir := function.indir
			full_text := "%NError! No full text.%N"
			create commentor.make
			commentor.set_expression ("s/^/			-- /g;s/\n/\n			-- /g")
		ensure
			valid_name: name /= Void
			valid_type: type /= Void
			valid_indir: indir >= 0
		end

	make_with_arguments (function: C_ARGUMENT; new_arguments: C_ARGUMENTS) is
			-- Set prototype `type' `indir' and `name' from `function'
			-- Use existing arguments
		require
			valid_function_argument: function /= Void
			valid_arguments: new_arguments /= Void
		do
			make (function)
			arguments := new_arguments
		ensure
			arguments_sed: arguments = new_arguments
		end

feature -- Access

	full_text: STRING
			-- original C prototype text

	file_name: STRING
			-- original C file name

	arguments: C_ARGUMENTS
			-- arguments for the function

	
feature -- Status setting

	add_argument (arg: C_ARGUMENT) is
		do
			arguments.extend (arg)
		end

	set_full_text (new_full_text: STRING) is
		do
			full_text := new_full_text
		end

	set_file_name (new_file_name: STRING) is
		do
			file_name := new_file_name
		end

feature -- Conversion to Eiffel text

	eiffel_text (include_directive: STRING): STRING is
			-- Eiffel text of external feature call for `Current' C prototype
		local
			td: C_TYPEDEF
			r: FMT_STRING
		do
			create r.make
			Result := r
			r.append ("%T")
			r.append (name)
			if arguments.count > 0 then
				r.append (" (")
				from arguments.start
				until arguments.after
				loop
					r.append (arguments.item.name)
					r.append (": ")
					td := arguments.item.typedef
					if td.indir + arguments.item.indir > 0 then
						r.append ("POINTER")
					elseif td.base.is_equal ("char") then
						r.append ("INTEGER")
					else
						r.append (td.base)
					end
					if arguments.index /= arguments.count then
						r.append ("; ")
					end
					arguments.forth
				end
				r.append (")")
			end
			if not type.is_equal ("void") then
				r.append (": ")
				if typedef.indir + indir > 0 then
					r.append ("POINTER")
				else
					if typedef.base.is_equal ("char") 
					or typedef.base.is_equal ("union") then
						r.append ("INTEGER")
					else 
						r.append (typedef.base)
					end
				end
			end
			r.append (" is %N^%T%Texternal%N")
			r.inject (to_comment)
			r.append ("%T%T%T%" C | ^%"%N%T%Tend%N%N")
			r.inject (include_directive)
		end

	to_comment: STRING is
			-- Convert to eiffel comment describing original C code
		local
			s: STRING
			r: FMT_STRING
		do
			create r.make
			Result := r
			r.append ("%T%T%T-- Parsed as:%N")
			r.append ("%T%T%T-- ^^ ^ (%N")
			r.inject (type)
			!!s.make (indir)
			s.fill_character ('*')
			r.inject (s)
			r.inject (name)
			from arguments.start
			until arguments.after
			loop
				r.append ("%T%T%T--     ^ ^^")
				r.inject (arguments.item.type)
				!!s.make (arguments.item.indir)
				s.fill_character ('*')
				r.inject (s)
				r.inject (arguments.item.name)
				if arguments.index /= arguments.count then
					r.append (",")
				end
				r.append ("%N")
				arguments.forth
			end
			r.append ("%T%T%T-- );%N")
			r.append ("%T%T%T--%N%T%T%T-- Original C code from ^:%N^%N")
			r.inject (file_name)
			r.inject (commentor.run (full_text))
		end

feature -- Implementation

	commentor: STRING_EDITOR

invariant

	arguments_valid: arguments /= Void

end -- class C_PROTOTYPE


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
