/*
  readfiles.ll

  Copyright (c) 1996 Roland Wunderling, Malte Zoeckler
  Copyright (c) 1998 Michael Meeks
  Copyright (c) 1998-99 Dragos Acostachioaie

  This file is part of DOC++.

  DOC++ is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the license, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

%{
#include <assert.h>
#include <stdio.h>
#include <sys/types.h>
#include "McDirectory.h"

#include "McString.h"
#include "McSorter.h"
#include "nametable.h"
#include "doc.h"

static NameTable	fileTable ;
static McString*	inputFile ;
static McString		fileName ;
static McString		currDir ;
static int		lineNr ;
static int obr=0,cbr=0;

static void startfile( const char* file, int line )
{
    lineNr   = line ;
    fileName = file ;
    *inputFile += char( 6 ) ;
    *inputFile += file ;
    *inputFile += char( 6 ) ;
    *inputFile += '\n' ;
}

extern "C" {
  int readfilesYYwrap()
    {
    return 1;
    }
}

%}

%x Include Includetwo CharConst StrConst Comment

%%
^[ \t]*"/*@Include:"[ \t]*	{ BEGIN(Includetwo) ; }
<Includetwo>[^ \t\n]*		{
                                  int                 tmpNr   = lineNr ;
                                  McString            tmpName = fileName ;
                                  McString            tmpDir  = currDir ;
                                  YY_BUFFER_STATE     tmpBuf  = YY_CURRENT_BUFFER ;
                                  readfile ( inputFile, yytext, 1 ,currDir) ;
                                  currDir=tmpDir;
                                  startfile( tmpName, tmpNr ) ;
                                  yy_switch_to_buffer( tmpBuf ) ;
                                  BEGIN(Includetwo) ;
				}
<Includetwo>[ \t]*"*/"[ \t]*\n        { *inputFile += *yytext ; lineNr++ ; BEGIN(0) ; }
^[ \t]*"//@Include:"[ \t]*	{ BEGIN(Include) ; }
<Include>[^ \t\n]*		{
				    int			tmpNr   = lineNr ;
				    McString		tmpName = fileName ;
				    McString		tmpDir  = currDir ;
				    YY_BUFFER_STATE	tmpBuf  = YY_CURRENT_BUFFER ;
				    readfile ( inputFile, yytext, 1 ,currDir) ;
				    currDir=tmpDir;
				    startfile( tmpName, tmpNr ) ;
				    yy_switch_to_buffer( tmpBuf ) ;
				    BEGIN(Include) ;
				}
<Include>.
<Include>\n			{ *inputFile += *yytext ; lineNr++ ; BEGIN(0) ; }


'                               {
                                    *inputFile += '\'';
                                    BEGIN(CharConst);
                                }
<CharConst>\\'                  { *inputFile += "\\'"; }
<CharConst>'                    {
                                    *inputFile += '\'';
                                    BEGIN(0);
                                }
\"                              {
                                    *inputFile += '"';
                                    BEGIN(StrConst);
                                }
<StrConst>\\\"                  { *inputFile += "\\\""; }
<StrConst>\"                    {
                                    *inputFile += '\"';
                                    BEGIN(0);
                                }
<CharConst,StrConst>\\\\        { *inputFile += "\\\\"; }
"/*"                            {
                                    *inputFile += "/*";
                                    BEGIN(Comment);
                                }
<Comment>"*/"                   {
                                    *inputFile += "*/";
                                    BEGIN(0);
                                }
"//".*\n                        { *inputFile += yytext; lineNr++; }

<CharConst,StrConst,Comment>\n  { *inputFile += '\n'; lineNr++; }
<CharConst,StrConst,Comment>.   { *inputFile += *yytext; }

"{"				{ *inputFile += '{' ; obr++ ; }
"}"				{ *inputFile += '}' ; cbr++ ; }
\r\n				{ *inputFile += '\n' ; lineNr++ ; }
\n\r				{ *inputFile += '\n' ; lineNr++ ; }
\r				{ *inputFile += '\n' ; lineNr++ ; }
\n				{ *inputFile += '\n' ; lineNr++ ; }
.				{ *inputFile += *yytext ; }
%%

class StringCompare {
public:
    int operator()(const char *t1,const char *t2) {
	 return stricmp(t1,t2);
    }
};

/** Read files prior to extracting documentation.

   @param in The input text to document
   @param file The name of the file to read
   @param startLine The starting line number of the file being scanned
   @param directory The name of the directory to scan, default NULL
   @param scanSubDirs Whether to scan sub-directories
*/
void	readfile( McString* in, const char* file, int startLine, 
		  const char *directory,int scanSubDirs)
{
    McString path;    
    
    /* If we're told to scan sub-directories and there's a directory, recurse
       to get all header files in sub-directories
    */
    if (scanSubDirs && directory) {
	McString d=directory;
	McDArray<char *> list;
        McDirectory::scan(d, list, "*");
#ifdef DEBUG
	if (verb)
	    printf("Scanning for subdirs in `%s', found %d files\n",
		   (const char *)d, list.size());
#endif
	int n=0;
	for (int i=0 ; i<list.size() ; i++) {	    
	    McString tmp=d;
	    tmp += McDirectory::pathDelimiter(); tmp+=list[i];
	    if (McDirectory::isDirectory(tmp)) {
		readfile(in,file,1,tmp,1);
		n++;
	    }
	    free(list[i]);
	}
#ifdef DEBUG
	if (verb)
	    printf("done scanning for subdirs in `%s', found %d files\n",
		   (const char *)d, n);
#endif
    }

    // Set our path to be the directory, if any
    if (directory)
	path=directory;
    
    if (file[0]==McDirectory::pathDelimiter()) 
	path=file;
    else {
	if (path.length())
	    if (path[path.length()-1]!=McDirectory::pathDelimiter())
		path+=McDirectory::pathDelimiter();
	path+=file; 
    }

    if( fileTable.has( path ) )
	return ;


    int slash=path.rindex(McDirectory::pathDelimiter());
    
    McString realFile;
	
    if (slash>-1){
	McString dir(path,0,slash+1);
	currDir = dir;
	realFile=McString(path,slash+1,path.length()-slash-1);
    } else {
	currDir="";
	realFile=path;
    }
    int d=realFile.index('*');
    if (d>-1) {
	McString dr=currDir;
	if (!dr.length()) {
	    dr=".";
	    dr+=McDirectory::pathDelimiter();
	}	
	McDArray<char *> list;
	McDirectory::scan(dr, list, realFile);

#ifdef DEBUG
       if (verb) 
	   printf("`%s': dir=`%s', %d files\n",
	     (char *)realFile, (char *)dr, list.size());
#endif
       for (int i=0 ; i<list.size() ; i++){
	   readfile(in,list[i], 1, dr);
	   free(list[i]);
       }
       return;
    } 

    if (McDirectory::isDirectory(path)) {
#ifdef DEBUG
	if (verb)
	    printf("`%s' is a directory, reading all entries\n",
	      (const char *)path);
#endif
	if (java) {
	    readfile(in,"*.java",1,path,1);
	} else {
	    readfile(in,"*.h*",1,realFile,1);
	}
	return;
    }

#ifdef DEBUG
    if(verb)
	printf("Opening `%s'\n", (const char*)path);
#endif

    FILE *newin = fopen( path, "r" ) ;
    if( newin )
    {
        yyin=newin;
        fileTable.add( 0, path ) ;
        inputFile = in ;
        if (showFilePath)
	    startfile( path, startLine ) ;
	else
	    startfile( file, startLine ) ;
        yy_switch_to_buffer( yy_create_buffer( yyin, YY_BUF_SIZE ) );
	BEGIN(0);
	int lastobr = obr;
	int lastcbr = cbr;
	obr = 0;
	cbr = 0;
	readfilesYYlex();
	if(obr != cbr)
	  fprintf(stderr, "Warning: %d opening `{', but %d closing `}' in file `%s'.\n",
	    obr, cbr, (const char *)path);
	obr = lastobr;
	cbr = lastcbr;
	
	fclose(yyin);
    }
    else
	fprintf(stderr, "Could not open `%s'\n", file);
}
