(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              more_util.mli                               *)
(****************************************************************************)

open Pp

val isSome : 'a option -> bool;;
val inSOME : 'a -> 'a option;;
val outSOME : 'a option -> 'a;;
val option_app : ('a -> 'b) -> 'a option -> 'b option;;

val implode_chars : char list -> string;;
val explode_chars : string -> char list;;
val string_of_char : char -> string;;

val p_atom : char Stream.t -> string;;

val ne_plist_with_sep :
   ('a Stream.t -> unit) -> ('a Stream.t -> 'b) -> 'a Stream.t -> 'b list;;
val plist : ('a Stream.t -> 'b) -> 'a Stream.t -> 'b list;;

val prlist : ('a -> 'b Stream.t) -> 'a list -> 'b Stream.t;;
val prlist_with_sep :
   (unit -> 'a Stream.t) -> ('b -> 'a Stream.t) -> 'b list -> 'a Stream.t;;
val prvect_with_sep :
   (unit -> 'a Stream.t) -> ('b -> 'a Stream.t) -> 'b array -> 'a Stream.t;;

val pr_spc : unit -> std_ppcmds
val pr_fnl : unit -> std_ppcmds
val pr_int : int -> std_ppcmds
val pr_str : string -> std_ppcmds
val pr_coma : unit -> std_ppcmds


type ('a,'b) choice =  Left of 'a | Right of 'b;;

(* $Id: more_util.mli,v 1.9 1999/06/29 07:47:19 loiseleu Exp $ *)
