(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                intmap.ml                                 *)
(****************************************************************************)
(* Association tables over int *)




open Baltree;;

type 'b binding =
  { key: int; data: 'b; prev: 'b list };;

type 'b t = 'b binding Baltree.t;;

let order x y = ( (-)) x y.key;;

let empty = Empty;;

let bind x y b =
  Some
    { key = x;
      data = y;
      prev = match b with None -> [] | Some b -> b.data :: b.prev };;

let add x y m =
  Baltree.modify (order x) (bind x y) m;;

let find x m =
  (Baltree.find (order x) m).data;;

let unbind = function
    Some({prev = x::l} as b) ->
      Some { key = b.key; data = x; prev = l }
  | _ -> None;;

let remove x m =
  Baltree.modify (order x) unbind m;;

let iter f m =
  let rec iter = function
    Empty -> ()
  | Node(l, b, r, _) ->
      iter l;
      f b.key b.data;
      List.iter (f b.key) b.prev;
      iter r
  in iter m;;

(* $Id: intmap.ml,v 1.5 1999/06/29 07:47:17 loiseleu Exp $ *)
