(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               impuniv.mli                                *)
(****************************************************************************)

open Names
open Pp

type universe = {u_sp : section_path ; u_num : int}
type relation = 
   Greater of bool * universe * relation (* if bool then > else >= *)
 | Equiv of universe
 | Terminal

type arc = Arc of universe * relation
and universes = (universe,arc) Fmavm.frozen_t

val dummy_univ : universe
val prop_univ : universe
val prop_univ_univ : universe
val prop_univ_univ_univ : universe
val empty_universes : universes
val initial_universes : universes

val new_univ : unit -> universe
val super : universe -> universe
val sup : universe * universe -> universe

val set_uniarc : universes -> unit
val get_uniarc : unit -> universes

val uni_ord : universe -> universe -> int
val uni_pred : ('a -> bool) -> 'a -> bool
val uni_or : (unit -> bool) -> (unit -> bool) -> bool
val uni_or_if : bool -> (unit -> bool) -> (unit -> bool) -> bool
val with_universes :
  ('a -> 'b) -> section_path * universes * 'a -> universes * 'b

val enforcegt : universe -> universe -> unit
val enforcegeq : universe -> universe -> unit
val enforceq : universe -> universe -> unit
val enforce_relation : universe -> relation -> unit
val merge_universes : section_path -> universes -> universes -> universes

val num_universes : universes -> int
val num_edges : universes -> int
val pr_uni : universe -> std_ppcmds
val pr_universes : universes -> std_ppcmds

(* $Id: impuniv.mli,v 1.9 1999/11/07 17:57:14 barras Exp $ *)
