/* (-*-c++-*-)
 * Time-stamp: <98/02/01 19:39:48 panic>
 * Authors:  The C-mix Team
 * Content:  C-Mix system: kill set calculations
 *
 * Copyright  1998. The TOPPS group at DIKU, U of Copenhagen.
 * Redistribution and modification are allowed under certain
 * terms; see the file COPYING.cmix for details.
 */

#ifndef __KILL_H__
#define __KILL_H__

#include "corec.h"
#include "ALoc.h"

void
pointerKillSet(ALocSet* resultSet, C_Decl* d);
// This funtion should return the objects that certainly will be killed
// when assigning through pointer d

void
calculateKillStmt(C_Stmt* s);
// This function calculates the kill set for statement s
// and stores it in the anno->kill field of s. Nothing is done if the
// killCalculated field is true.

ALocSet* killStmt(C_Stmt* s);
// Returns the kill set for statement s, by first calling calculateKillStmt

void
calculateKillJump(C_Jump* j);
// This function calculates the kill set for jump statement j, i.e. which
// objects will certainly be killed when execution continues at j.  The
// kill set is stored in the anno->kill field of j. Nothing is done if the
// killCalculated field is true.

void
calculateKillBB(C_BasicBlock* b);
// This function calculates the kill set for basic block b, i.e. which
// objects will certainly be killed when execution continues at b.
// The kill set is stored in the anno->kill field of b. Nothing is done if
// the killCalculated field is true.

void
calculateKillFunDecl(C_Decl* d);
// This function calculates the kill set for function f declared in
// declaration d, i.e. which objects certainly will be killed by a call to
// f. The kill set is stored in the anno->kill field of d. Nothing is done
// if the killCalculated field is true.

#endif



