# librules.mk - a library of convenient rules and macros for debian/rules files
#
# Copyright  1999 Antti-Juhani Kaijanaho.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this file, to deal in this file without
# restriction, including without limitation the rights to use, copy,
# modify, merge, publish, distribute, sublicense, and/or sell copies
# of this file, and to permit persons to whom this file is furnished
# to do so, subject to the following condition: The above copyright
# notice and this permission notice shall be included in all copies or
# substantial portions of this file.
#
# THIS FILE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FIT- NESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL SOFTWARE IN THE PUBLIC INTEREST,
# INC.  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
# IN CONNECTION WITH THIS FILE OR THE USE OR OTHER DEALINGS IN THIS
# FILE.
#
# Except as contained in this notice, the name of the author(s) of
# this file shall not be used in advertising or otherwise to promote
# the sale, use or other dealings in this file without prior written
# authorization from the author(s).

# This file is set up to be compliant with Debian Standards Version
# 3.1.0.

default:
	@echo You need to specify a target.
	@exit 1

build: debian/stamp/build
binary: binary-indep binary-arch
binary-arch: debian/stamp/binary/arch
binary-indep: debian/stamp/binary/indep
clean: clean-build clean-binary

clean-build: clean-build-std
clean-binary: clean-binary-std

debian/stamp/binary/arch: debian/stamp/build
debian/stamp/binary/indep: debian/stamp/build

.PHONY: default build binary binary-arch binary-indep \
	clean clean-build clean-binary

DEB_BUILD_ARCH       = $(shell dpkg-architecture -qDEB_BUILD_ARCH)
DEB_BUILD_GNU_TYPE   = $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)
DEB_BUILD_GNU_CPU    = $(shell dpkg-architecture -qDEB_BUILD_GNU_CPU)
DEB_BUILD_GNU_SYSTEM = $(shell dpkg-architecture -qDEB_BUILD_GNU_SYSTEM)
DEB_HOST_ARCH        = $(shell dpkg-architecture -qDEB_HOST_ARCH)
DEB_HOST_GNU_TYPE    = $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)
DEB_HOST_GNU_CPU     = $(shell dpkg-architecture -qDEB_HOST_GNU_CPU)
DEB_HOST_GNU_SYSTEM  = $(shell dpkg-architecture -qDEB_HOST_GNU_SYSTEM)


install         := install -o root -g root
install_exec    := $(install) -m 0755 -s
install_nonex   := $(install) -m 0644
install_dir     := $(install) -m 0755 -d
install_script  := $(install) -m 0755
install_symlink := ln -s
gzip            := gzip -9
strip_lib       := strip --strip-unneeded

tmpdir := $(shell pwd)/debian/tmp

# These must not be :='s!
rootdir = $(tmpdir)/$(package)
ctldir = $(rootdir)/DEBIAN
bindir = $(rootdir)/usr/bin
docdir = $(rootdir)/usr/share/doc/$(package)
exampledir = $(docdir)/examples
mandir = $(rootdir)/usr/share/man
elispdir = $(rootdir)/usr/share/emacs/site-lisp
emacs_d_dir = $(rootdir)/etc/emacs/site-start.d
man1dir = $(mandir)/man1
sharedir = $(rootdir)/usr/share/$(package_base)
libdir = $(rootdir)/usr/lib/$(package_base)
docbasedir = $(rootdir)/usr/share/doc-base
usrlib = $(rootdir)/usr/lib
includedir = $(rootdir)/usr/include

ifeq ($(native_pkg),yes)
librules_changelog=changelog
else
librules_changelog=changelog.Debian
endif

define prebinary
	$(RM) -r $(rootdir)
	$(install_dir) $(ctldir)
	$(install_script) debian/prerm.$(package) $(ctldir)/prerm
	$(install_script) debian/postinst.$(package) $(ctldir)/postinst
	$(install_dir) $(docdir)
	$(install_nonex) debian/copyright $(docdir)
	$(install_nonex) debian/changelog $(docdir)/$(librules_changelog)
	$(gzip) $(docdir)/$(librules_changelog)
endef

define postbinary
	chmod -R g-s $(rootdir)
	dpkg-gencontrol -isp -p$(package) -P$(rootdir)
	dpkg --build $(rootdir) ..
endef

clean-build-std:
	rm -f debian/stamp/build

clean-binary-std:
	rm -f debian/stamp/binary/*
	rm -f debian/files debian/substvars
	rm -rf $(tmpdir)