------------------------------------------------------------------------------
--                                                                          --
--                            GNATELIM COMPONENTS                           --
--                                                                          --
--                       G N A T E L I M . O P T I O N S                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- Gnatelim is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnatelim is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Gnatelim is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT).                                                         --
--                                                                          --
-- Gnatelim was originally developed by Alain Le Guennec                    --
--                                                                          --
-- Gnatelim  is  now  maintained  by  Ada  Core  Technologies  Inc          --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

package GNATELIM.Options is

   Verbose_Mode : Boolean := False;
   --  '-v' parameter
   --  In vebose mode gnaelim generates in stdout the version information in
   --  the form of Ada comments. Also generates in stderr some messages
   --  reflecting the main step of the analysis made by gnatelim.

   Skip_Missed_Units : Boolean := True;
   --  '-m' parameter
   --  If some unit is mentioned in the bind file, but this unit is missed in
   --  a set of tree files, if Skip_Missed_Units flag is set ON, this unit is
   --  skiped in the analyziz performed by gnatelim. Otherwise gnatelim
   --  checks if the given unit should be presented by a set of tree files
   --  processed by gnatelim and generates an error message if needed.

   Dont_Eliminate_In_RTS : Boolean := True;
   --  '-a' parameter
   --  When called without '-a' parameter, gnatelim generates Eliminate pragmas
   --  only for units which does not belong to the GNAT Run-Time Library (RTL).
   --  When called with '-a' parameter, gnatelim process RTL components also
   --  and thenerates Eliminate pragmas for those of them for which the
   --  compiler does not generate implicit calls


end GNATELIM.Options;