/*****************************************************************************
**
** iopl.c
*/
static char rcsid[] __attribute__((unused)) = "$Id: iopl.c,v 0.0 1999/12/02 22:28:02 fox Exp $";
/*
**
** Acquire/Relinquish I/O port access privileges.
**
** Copyright (C) 1999  Omer Zak (omerz@actcom.co.il)
**
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the 
** Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
** Boston, MA  02111-1307  USA.
**
******************************************************************************
**
** Bug reports and fixes - to  P.J.H.Fox (fox@roestock.demon.co.uk)
** Note:  by sending unsolicited commercial/political/religious
**        E-mail messages (known also as "spam") to any E-mail address
**        mentioned in this file, you irrevocably agree to pay the
**        receipient US$500.- (plus any legal expenses incurred while
**        trying to collect the amount due) per unsolicited
**        commercial/political/religious E-mail message - for
**        the service of receiving your E-mail message.
**
*****************************************************************************/

#include <unistd.h>
#include <errno.h>
#include "iopl.h"

/****************************************************************************/

#ifdef _OS2_
unsigned 
iopl(unsigned port)
{
	return (0);
}
#endif /* _OS2_ */

#ifdef __DJGPP__
unsigned 
iopl(unsigned port)
{
	return (0);
}
#endif /* __DJGPP__ */


/****************************************************************************/

/* Acquire I/O port privileges needed for ISA PnP configuration.
** The return value is 0 on success, or the value of errno on failure.
*/
int
acquire_pnp_io_privileges(void)
{
  int ret;
#ifdef _AXP_
  /* ALPHA only has ioperm, apparently, so cover all with one permission */
  ret = ioperm(MIN_READ_ADDR, WRITEDATA_ADDR - MIN_READ_ADDR + 1, 1);
#else
  /*
   * Have to get unrestricted access to io ports, as WRITE_DATA port > 0x3ff
   */
  ret = iopl(3);
#endif

  if (ret < 0) {
    return(errno);
  }
  else {
    return(0);
  }
}

/* Relinquish I/O port privileges needed for ISA PnP configuration.
** The return value is 0 on success, or the value of errno on failure.
*/
int
relinquish_pnp_io_privileges(void)
{
  int ret;
#ifdef _AXP_
  ret = ioperm(MIN_READ_ADDR, WRITEDATA_ADDR - MIN_READ_ADDR + 1, 0);
#else
  ret = iopl(0);
#endif

  if (ret < 0) {
    return(errno);
  }
  else {
    return(0);
  }
}

/****************************************************************************/

/* End of iopl.c */
