/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_INFOPANES_H
#define GNOME_APT_INFOPANES_H

#include "gnome-apt.h"
#include "cache.h"
#include "gdeb/gdeb.h"

class GAptInfoPanes : public GAptCacheFile::CacheView, 
                      public GDeb::Package {
public:
  GAptInfoPanes();
  virtual ~GAptInfoPanes();

  GtkWidget* widget() { return gd_.widget(); }

  void set_hidden(bool state);
  bool get_hidden() { return !GTK_WIDGET_VISIBLE(gd_.widget()); }

  void set_selection(pkgCache::Package* pkg);

  void set_cache    (GAptCache* cache);

  // Interface for GDeb::Package
  // Stuff to display
  virtual string Name();
  virtual string Version();
  virtual string Description_Short();
  virtual string Description_Long();
  virtual string Section();
  virtual string Priority();
  virtual string Size();
  virtual string Installed_Size();
  virtual string Maintainer();
  virtual string Status();
  virtual string Current_Version();
  virtual string Architecture();
  virtual string Source();
  virtual string Filename();
  virtual bool   Essential();
  virtual bool   Downloadable();
  virtual bool   Automatic();
  virtual vector<string> Provides();
  virtual vector<string> PreDepends();
  virtual vector<string> Depends();
  virtual vector<string> Recommends();
  virtual vector<string> Suggests();
  virtual vector<string> Conflicts();
  virtual vector<string> Replaces();
  
  // Actions
  virtual void Install();
  virtual void Delete();
  virtual void Keep();

private:
  GDeb gd_;

  pkgCache::Package* pkg_;
  GAptCache* cache_;

};


#endif
