/*
   options.h : fbgetty options 
   Part of fbgetty 
   Copyright (C) 1999 Yann DRONEAUD (lch@multimania.com). 

   fbgetty is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   fbgetty is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/

#ifndef _OPTIONS_H_
#define _OPTIONS_H_

#ifndef LOGIN_PROGRAM
#define LOGIN_PROGRAM "/bin/login"
#endif

#ifndef LOGIN_PROMPT
#define LOGIN_PROMPT "%n login: "
#endif

#ifndef ISSUE_FILE
#define ISSUE_FILE "/etc/issue"
#endif

#ifndef ISSUE_REFRESH
#define ISSUE_REFRESH 0 /* No refresh */
#endif

#ifndef LOGIN_TIMEOUT
#define LOGIN_TIMEOUT 0 /* No time out */
#endif

#ifndef TTY_DEVICE
#define TTY_DEVICE NULL
#endif

#ifdef USE_FRAME_BUFFER
 #ifndef FB_DEVICE
 #define FB_DEVICE NULL
 #endif
#endif /* USE_FRAME_BUFFER */

/* All the variable is here */
typedef struct fbgetty_options_t
{
  char *tty_device;
  int   tty_fd;           /* internal */
  int   tty_number;       /* internal */
#ifdef USE_FRAME_BUFFER
  char *fb_device;
  int   fb_fd;            /* internal */
  int   fb_number;        /* internal */
#endif
  int   screen_clear;
  char *issue_file;
  int   issue_refresh;
  char *login_prompt;
  int   login_hide;
  int   login_timeout; 
  char *login_program;
  char *login_name;       /* internal */
  int   login_name_valid; /* internal */
} fbgetty_options_t;

/* all features are centralized in fgoptions */
extern fbgetty_options_t *fgoptions;

void parse_command_line(int argc, char *argv[]);

#ifndef __GLIBC__
extern char *program_invocation_short_name;
extern char *program_invocation_name;
#endif

#endif /* _OPTIONS_H_ */
