#include <stdio.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>
#include <asm/types.h>
#include <linux/serial.h>
#include "dbootstrap.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"

#define SEDCOMMAND "sed"

extern int configure_timezone(void);

static int require_swap (void) {
  if ( (swapon_partitions == NULL) &&
       (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL) &&
       (noSwap == 0) ) {
    problemBox(_("Your swap partition has not been set up.\nBefore you begin installation, you must first partition your disk, and then initialize and mount your root filesystem, and initialize a swap partition.\nPlease use the main menu to complete any of those steps that you have not done, and then use the main menu to return to this step."), _("No swap partition found"));
    return 1;
  }
  return 0;
}

/* XXX: This does not work with read-only filesystems, which is most
 * likely only solvable from modconf, why don't we chroot when we run
 * modconf, we can simply copy the libraries, IMO - Ben */
static int update_cdrom_symlink (void) {
  struct stat statbuf;
  int pos;
  
  if ( (! lstat("/dev/cdrom", &statbuf) ) &&
       S_ISLNK((&statbuf)->st_mode) && 
       NAME_ISDIR("/target/dev", &statbuf) ) {
    pos = readlink("/dev/cdrom", prtbuf, 20);
    prtbuf[pos] = '\0';
    symlink(prtbuf, "/target/dev/cdrom");
  }
  return 0;
}

#ifdef SCSI_FLOPPY
/* XXX: neither does this - Ben */
static int update_sfd0_symlink (void) {
  struct stat statbuf;
  int pos;
  
  if ( (! lstat("/dev/sfd0", &statbuf) ) &&
       S_ISLNK((&statbuf)->st_mode) && 
       NAME_ISDIR("/target/dev", &statbuf) ) {
    pos = readlink("/dev/sfd0", prtbuf, 20);
    prtbuf[pos] = '\0';
    symlink(prtbuf, "/target/dev/sfd0");
  }
  return 0;
}
#endif

#if #cpu (m68k)
static int update_fdisk_symlink (void) {
  char *target;

  /* determine target of symlink */
  if (strcmp(Arch2, "Atari") == 0)
	  target = "atari-fdisk";
  else if (strcmp(Arch2, "Amiga") == 0)
	  target = "amiga-fdisk";
  else if (strcmp(Arch2, "Macintosh") == 0)
	  target = "mac-fdisk";
  else if (strcmp(Arch2, "VME") == 0)
	  target = "../usr/sbin/pmac-fdisk";
  else
	  return -1;

  /* remove an existing /sbin/fdisk (ignore if not existed) */
  unlink("/target/sbin/fdisk");
  symlink(target, "/target/sbin/fdisk");
  return 0;
}
#endif

#if #cpu (powerpc)
static int update_fdisk_symlink (void) {
  char *target;

  /* determine target of symlink */
  if (strcmp(Arch2, "apus") == 0)
	  target = "amiga-fdisk";
  else if (strcmp(Arch2, "BeBox") == 0)
	  target = "ddisk";
  else if (strcmp(Arch2, "CHRP") == 0)
	  target = "ddisk";
  else if (strcmp(Arch2, "MBX") == 0)
	  target = "ddisk";
  else if (strcasecmp(Arch2, "Power") == 0)
	  target = "pmac-fdisk";
  else if (strcasecmp(Arch2,"iMac") == 0)
	  target = "pmac-fdisk";
  else if (strcmp(Arch2, "PReP") == 0)
	  target = "ddisk";
  else
	  return -1;

  /* remove an existing /sbin/fdisk (ignore if not existed) */
  unlink("/target/sbin/fdisk");
  symlink(target, "/target/sbin/fdisk");
  return 0;
}
#endif


#ifdef SERIAL_CONSOLE
static int
update_console_info (void)
{
  char tty[16];
  int ttyline = -1;
  int err = 0;
  FILE *F;
  /* serial console setup:
   *  1/ relink /dev/console to /dev/ttyS<n> *only* if < 2.0 kernel
   *  2/ edit /target/etc/inittab to enable a T<n> line and set emulation type
   *  2b/ do the same thing with /target/etc/inittab.real
   *  3/ add ttyS<n> & cua<n> to /target/etc/securetty
   */
  if (!strncmp(kver, "2.0", 3)) {
    strcpy(tty, ttyname(0));
    if (!strncmp(tty, "/dev/cua", 8))
      ttyline = tty[8] - '0';
    else if (!strncmp(tty, "/dev/ttyS", 9))
      ttyline = tty[9] - '0';
  }
  else {
	struct serial_struct sr;
    if (ioctl(0, TIOCGSERIAL, &sr) < 0)
      strcpy(tty, "/dev/console");
    else {
      ttyline = sr.line;
      sprintf(tty, "/dev/ttyS%d", ttyline);
    }
  }
  if (ttyline >= 0) {
    char *term = getenv("TERM");
    if (!term||!*term) term="vt100";
    /* 1 */
    if (!strncmp(kver, "2.0", 3)) {
      /* 2.0 kernel only */
      unlink("/target/dev/console");
      symlink(tty, "/target/dev/console");
    }
    /* 2 */
    sprintf(prtbuf,
	    SEDCOMMAND
	    " -e "
	    "'"
	    "s/^#\\(T%d:.\\+dpkg-reconfigure.*\\)/\\1/; "
	    "s/^\\([1-6]\\):/#\\1:/"
	    "'"
	    "< %s > %s",
	    ttyline,
	    "/target/etc/inittab",
	    "/target/etc/inittab.tmp");
    if (execlog(prtbuf, LOG_INFO) ||
	rename("/target/etc/inittab.tmp", "/target/etc/inittab"))
    {
      problemBox("Error writing /target/etc/inittab", "Write error");
      return 1;
    }
    /* 2b */
    sprintf(prtbuf,
	    SEDCOMMAND
	    " -e 's/^#\\(T%d:.\\+\\)[ \t][a-zA-Z0-9]\\+[ \t]*$/\\1 %s/'"
	    " -e 's/^\\([1-6]\\):/#\\1:/' < %s > %s",
	    ttyline, term,
	    "/target/etc/inittab.real",
	    "/target/etc/inittab.real.tmp");
    if (execlog(prtbuf, LOG_INFO) ||
	rename("/target/etc/inittab.real.tmp","/target/etc/inittab.real"))
    {
      problemBox("Error writing /target/etc/inittab.real", "Write error");
      return 1;
    }
    /* 3 */
    F = fopen("/target/etc/securetty", "a");
    if (F) {
      err = fprintf(F, "ttyS%d\ncua%d\n", ttyline, ttyline) <= 0;
      fclose(F);
    }
    else
      err = 1;
    if (err) {
      problemBox("Error writing /target/etc/securetty", "Write error");
      return 1;
    }
  }
  return 0;
}
#endif

static int write_environment (void) {
  FILE *etcenv;

  if (NULL == (etcenv = fopen("/target/etc/environment", "w"))){
    problemBox(_("Can't open /target/etc/environment "), _("Write error"));
    return 1;
  }
#ifndef USE_LANGUAGE_CHOOSER
  fprintf(etcenv, "LANG=%s\n", _("C"));
#else
  if (lang == NULL)
    fprintf(etcenv, "LANG=%s\n", _("C"));   /* MSS: not very good */
  else
    fprintf(etcenv, "LANG=%s\n", lang->locale);
#endif
  fclose(etcenv);
  return 0;
}

static int write_fstab (void) {
  FILE *fstab;
  struct fdisk_partition *p;
  char* fsname;
  char* fsopts;

  if (NULL == (fstab = fopen("/target/etc/fstab", "w"))) {
    problemBox(_("Can't open /target/etc/fstab "), _("Write error"));
    return 1;
  }

  if (is_nfs_partition("/target")) {
	fsname = "nfs";
	fsopts = "rw,rsize=8192,wsize=8192,nolock";
  }
  else {
	fsname = "ext2";
	fsopts = "defaults,errors=remount-ro";
  }
  fprintf(fstab,
	  _("# /etc/fstab: static file system information.\n"
	    "#\n"
	    "# <file system>\t<mount point>\t<type>\t<options>\t\t\t<dump>\t<pass>\n"));
  fprintf(fstab,
	  "%s\t/\t\t%s\t%s\t0\t1\n",
	  Root->name, fsname, fsopts);

  if (swapon_partitions != NULL) {
    p = swapon_partitions;
    while (p) {
      fprintf(fstab,
	      "%s\tnone\t\tswap\tsw\t\t\t0\t0\n",
	      p->name);
      p=p->next_in_use;
    }
  }

  fprintf(fstab,
	  "proc\t\t/proc\t\tproc\tdefaults\t\t\t0\t0\n");
  fprintf(fstab,
	    "/dev/fd0\t/floppy\t\tauto\tdefaults,user,noauto\t\t0\t0\n"
	    "/dev/cdrom\t/cdrom\t\tiso9660\tdefaults,ro,user,noauto\t\t0\t0\n");

  fclose(fstab);

  sprintf(prtbuf,
	  SEDCOMMAND
	  " -n '/target\\//p' /proc/mounts | "
	  SEDCOMMAND
	  " -e 's/target\\///; s/ 0 0/\t\t\t0\t2/; s/ rw /\tdefaults/;' "
	  " >> /target/etc/fstab 2>/dev/null");
  if (execlog(prtbuf, LOG_INFO)) {
    problemBox(_("Error writing /target/etc/fstab "),_("Write error"));
    return 1;
  }
  return 0;
}

#ifdef FONT
static int write_etc_kbd (void) {
  FILE *etc_kbd;
  if (NULL == (etc_kbd = fopen("/target/etc/console-tools/config", "a"))) {
    problemBox(_("Can't open /target/etc/console-tools/config "), _("Write error"));
    return 1;
  }
  fprintf(etc_kbd, "CONSOLE_FONT=%s\n", FONT);
  fclose(etc_kbd);
  return 0;
}
#endif

int configure_base (void) {
  struct stat statbuf;

  if ( require_swap() ) return 1;

  if (! NAME_ISREG( "/target/etc/debian_version", &statbuf) ||
      ! NAME_ISREG( "/target/sbin/init", &statbuf) ) {
    problemBox(_("You have to install base for configuring it"),_("Base not installed"));
    return 1;
  }

  if ( write_fstab() ) return 1;

#if #cpu (m68k)
  /* don't do keymapping for VME serial console */
  if (strcmp(Arch2, "VME") == 0)
    unlink("/target/bin/loadkeys");
#endif

#ifdef FONT
    if ( write_etc_kbd() ) return 1;
#endif

  configure_timezone();

  update_cdrom_symlink();

#ifdef SCSI_FLOPPY
  update_sfd0_symlink();
#endif

  if (!strncmp(kver, "2.0", 3)) {
    /* 2.0 kernel only: first update /dev/console then eventually
     * change it to /dev/ttyS<n> latter in update_console_info() */
    unlink("/target/dev/console");
    symlink("tty0", "/target/dev/console");
  }

#if #cpu (m68k)
  if (strcmp(Arch2, "VME") == 0)
    update_console_info();
  update_fdisk_symlink();
#endif

#if #cpu (powerpc)
  update_console_info();
  update_fdisk_symlink();
#endif

#if #cpu (sparc)
  update_console_info();
#endif

#if #cpu (i386)
  update_console_info();
#endif

#if #cpu (arm)
  update_console_info();
#endif

#if #cpu (alpha)
  update_console_info();
#endif

  /* If on serial console, get rid of kbd files and setserial startup.
     The kbd package will be purged during final configuration. */
  if (serialConsole >= 0)
  {
    unlink("/target/etc/rcS.d/S05keymaps-lct.sh");
    unlink("/target/etc/rcS.d/S48console-screen.sh");
    write_userconfig("SERIALCONSOLE", "true");
    /* Temporary hack, we should fix the setserial script so it doesn't
       trash serial consoles. MDP */
    unlink("/target/etc/rcS.d/S30setserial");
    unlink("/target/etc/rc0.d/K30setserial");
    unlink("/target/etc/rc6.d/K30setserial");
  }

  write_environment();

  unlink("/target/sbin/unconfigured.sh");

  return 0;
}

int configure_drivers (void) {
  struct stat statbuf;

  if (! NAME_ISEXE("/usr/bin/whiptail", &statbuf))
      symlink("/target/usr/bin/whiptail", "/usr/bin/whiptail");

  setenv("LANG", _("C"), 1);
  add_modules_from_floppy();

  snprintf (prtbuf, sizeof (prtbuf), "/target/lib/modules/%s", kver);
  if (! NAME_ISDIR (prtbuf, &statbuf)) {
    snprintf (prtbuf, sizeof (prtbuf), _("No modules were found in /target/lib/modules/%s that could be configured. Please install the modules first."), kver);
    problemBox (prtbuf, _("Problem"));
    return -1;
  }
  execlog("depmod -a", LOG_INFO);

  fullscreen_execlog("/target/usr/sbin/modconf"
                     " --exclude-section pcmcia"
                     " --target /target"
                     " --run-shell cdromsymlink"
                     " --libdir /tmp/drivers"
                     " --helpdir /target/usr/share/modconf"
                     " --tty /dev/tty");

  update_cdrom_symlink();

  return 0;
}
