#! /bin/sh
# hwclock.sh	Set and adjust the hardware clock, according to the UTC
#		setting in /etc/default/rcS (see also rcS(5)).
#

. /etc/default/rcS
case "$UTC" in
       no|"") UTCARG=no  ;;
       yes)   UTCARG=yes ;;
       *)     echo "$0: unknown UTC setting: \"$UTC\"" >&2 ;;
esac

Arch=$(awk '/machine/ {print $3}' /proc/cpuinfo)

case "$Arch" in
    CHRP)
	CLOCKPROG=hwclock
	ADJUSTARG=--adjust
	WRITEARG=--systohc
	SHOWARG=--show
	[ "$UTCARG" = yes ] && UTCARG="--utc"
    ;;
    Power*|iMac*|Power[Bb]ook*)
	CLOCKPROG=clock
	ADJUSTARG=-a
	WRITEARG=-w
	SHOWARG=-r
	[ "$UTCARG" = yes ] && UTCARG="-u"
    ;;
    *)
    	exit 0
    ;;
esac

case "$1" in
	start)
		if [ ! -f /etc/adjtime ]
		then
			echo "0.0 0 0.0" > /etc/adjtime
		fi
		$CLOCKPROG $ADJUSTARG $UTCARG >/dev/null 2>&1
		[ "$CLOCKPROG" = hwclock ] && $CLOCKPROG --hctosys
		#
		#	Now that /usr/share/zoneinfo should be available,
		#	announce the local time.
		#
		if [ "$VERBOSE" != no ]
		then
			echo
			echo "Local time: `date`"
			echo
		fi
		;;
	stop|restart|force-reload|reload)
		$CLOCKPROG $WRITEARG $UTCARG >/dev/null 2>&1
		if [ "$VERBOSE" != no ]
		then
			echo "Hardware clock updated to `date`."
		fi
		;;
	show)
		$CLOCKPROG $SHOWARG $UTCARG
		;;
	*)
		echo "Usage: hwclock.sh {start|stop|reload|show}" >&2
		echo " start sets kernel clock from hardware clock" >&2
		echo " stop and reload set hardware clock from kernel clock" >&2
		echo " show displays the time from the hardware clock" >&2
		exit 1
		;;
esac

