/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.java.io.SimpleFileFilter;

public class AdaptiveClassLoader
extends ClassLoader {
    private static int generationCounter = 0;
    private int generation;
    private Hashtable cache = new Hashtable();
    private Vector repository;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZipOrJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var5_4 = null;
        if (zipFile == null) return bl;
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        {
            catch (ZipException zipException) {
                bl = false;
                Object var5_5 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
            catch (IOException iOException) {
                bl = false;
                Object var5_6 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() != classCacheEntry.lastModified;
        return bl;
    }

    public synchronized boolean shouldReload() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == 0L) {
                return true;
            }
            if (l == classCacheEntry.lastModified) continue;
            return true;
        }
        return false;
    }

    public AdaptiveClassLoader reinstantiate() {
        return new AdaptiveClassLoader(this.repository);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            clazz = classCacheEntry.loadedClass;
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!this.securityAllowsClass(string)) {
            return this.loadSystemClass(string, bl);
        }
        try {
            clazz = this.loadSystemClass(string, bl);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (Exception exception) {
            clazz = null;
        }
        Enumeration enumeration = this.repository.elements();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            File file = (File)enumeration.nextElement();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray == null) continue;
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class loadSystemClass(String string, boolean bl) throws NoClassDefFoundError, ClassNotFoundException {
        Class<?> clazz = this.findSystemClass(string);
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(string, classCacheEntry);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return true;
            }
            int n = string.lastIndexOf(46);
            securityManager.checkPackageDefinition(n > -1 ? string.substring(0, n) : "");
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = string.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            byte[] byArray;
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        byte[] byArray;
        ZipFile zipFile;
        block4: {
            byte[] byArray2;
            block3: {
                String string2 = string.replace('.', '/') + ".class";
                zipFile = new ZipFile(file);
                try {
                    ZipEntry zipEntry = zipFile.getEntry(string2);
                    if (zipEntry != null) {
                        classCacheEntry.origin = file;
                        byArray2 = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                        Object var7_9 = null;
                        break block3;
                    }
                    byArray = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    zipFile.close();
                    throw throwable;
                }
            }
            zipFile.close();
            return byArray2;
        }
        Object var7_10 = null;
        zipFile.close();
        return byArray;
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            Enumeration enumeration = this.repository.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                if (file.isDirectory()) {
                    inputStream = this.loadResourceFromDirectory(file, string);
                } else if (string.endsWith(".initArgs")) {
                    File file2 = new File(file.getParent());
                    inputStream = this.loadResourceFromDirectory(file2, string);
                } else {
                    inputStream = this.loadResourceFromZipfile(file, string);
                }
                if (inputStream != null) break;
            }
        }
        return inputStream;
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream loadResourceFromZipfile(File var1_1, String var2_2) {
        block11: {
            block10: {
                var3_3 = null;
                try {
                    try {
                        var3_3 = new ZipFile(var1_1);
                        var7_4 = var3_3.getEntry(var2_2);
                        if (var7_4 != null) {
                            var6_8 = var3_3.getInputStream((ZipEntry)var7_4);
                            var5_11 = null;
                            if (var3_3 == null) return var6_8;
                            break block10;
                        }
                        var6_9 = null;
                        break block11;
                    }
                    catch (IOException var7_5) {
                        var6_10 = null;
                        var5_13 = null;
                        if (var3_3 == null) return var6_10;
                        try {
                            var3_3.close();
                            return var6_10;
                        }
                        catch (IOException var7_6) {
                            // empty catch block
                        }
                        return var6_10;
                    }
                }
                catch (Throwable var4_15) {
                    var5_14 = null;
                    if (var3_3 == null) throw var4_15;
                    try {}
                    catch (IOException var7_7) {
                        throw var4_15;
                    }
                    var3_3.close();
                    throw var4_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 71->78)] { 
lbl37:
            // 1 sources

            var3_3.close();
            return var6_8;
lbl39:
            // 1 sources

            catch (IOException var7_4) {
                // empty catch block
            }
            return var6_8;
        }
        var5_12 = null;
        if (var3_3 == null) return var6_9;
        ** try [egrp 2[TRYBLOCK] [2 : 71->78)] { 
lbl46:
        // 1 sources

        var3_3.close();
        return var6_9;
lbl48:
        // 1 sources

        catch (IOException var7_4) {
            // empty catch block
        }
        return var6_9;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this.repository.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            File file = (File)enumeration.nextElement();
            if (file.isDirectory()) {
                object2 = string.replace('/', File.separatorChar);
                object = new File(file, (String)object2);
                if (!((File)object).exists()) continue;
                try {
                    return new URL("file", null, ((File)object).getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            try {
                object2 = new ZipFile(file.getAbsolutePath());
                object = ((ZipFile)object2).getEntry(string);
                if (object == null) continue;
                try {
                    return new URL("jar:file:" + file.getAbsolutePath() + "!/" + string);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public AdaptiveClassLoader(Vector vector) throws IllegalArgumentException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            File file;
            Object e = enumeration.nextElement();
            try {
                file = (File)e;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Object " + e + "is not a valid \"File\" instance");
            }
            File[] fileArray = SimpleFileFilter.fileOrFiles(file);
            if (fileArray == null) continue;
            int n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                if (!file.exists()) {
                    throw new IllegalArgumentException("Repository " + file.getAbsolutePath() + " doesn't exist!");
                }
                if (!file.canRead()) {
                    throw new IllegalArgumentException("Do not have read access for file " + file.getAbsolutePath());
                }
                if (!file.isDirectory() && !this.isZipOrJarArchive(file)) {
                    throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or zip/jar file" + " or if it's a zip/jar file then it is corrupted.");
                }
                ++n;
            }
        }
        this.repository = vector;
        this.generation = generationCounter++;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        public boolean isSystemClass() {
            return this.origin == null;
        }

        ClassCacheEntry() {
        }
    }
}

