/*
	GNUJSP - a free JSP1.0 implementation
	Copyright (C) 1999, Yaroslav Faybishenko <yaroslav@cs.berkeley.edu>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, =
USA.
*/
package org.gjt.jsp.test;

import java.io.IOException;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.gjt.jsp.HttpJspPageImpl;

/**
 * This is a test example for a custom superclass of the 
 * generated servlet.
 * It does not extend HttpJspPageImpl but follows
 * Spec 1.0 chapter 3.2.4.
 */

public class TestHttpJspPageImpl2 
    extends HttpServlet
    implements HttpJspPage
{
    private ServletConfig  config=null;

    final public void init (ServletConfig config) throws ServletException {
	this.config      = config;
	super.init (this.config);
	jspInit ();
    }

    final public void service (HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
    {
	    _jspService (req, res);
    }
    final public ServletConfig getServletConfig() {
	return config;
    }
    final public void destroy () {
	jspDestroy ();
    }
    public void _jspService(HttpServletRequest req, 
	HttpServletResponse res) 
	throws ServletException, IOException
    {}
    public void jspInit() {}
    public void jspDestroy() {}

    public String getValue() {
	return "value1";
    }
}



