package org.gjt.jsp.test;
/*
	Testclasses for GNUJSP - a free JSP1.0 implementation
	Copyright (C) 1999, Carsten Heyl <alph@gjt.org>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, =
USA.
*/


import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletConfig;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gjt.jsp.jsdk20.HttpServletRequestWrapper;

/**
 *
 * helper servlet to test servlet include 
 * with jsdk 2.0.
 *
 * FIXME: check notes below! (alph)
 * Apache zone.properties:
 *
 * servlet.gnujsptestservlet.code=org.gjt.jsp.test.GNUJSPTestServlet
 * servlets.startup=gnujsptestservlet
 *
 */

public class GNUJSPTestServlet extends HttpServlet {
    public void init (ServletConfig config) throws ServletException {
	super.init (config);
	System.err.println("GNUJSPTestServlet initialized.");
    }

    public void service (HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
    {
	ServletOutputStream out = res.getOutputStream();

	String reqURI = req.getRequestURI();
	String zone = req.getParameter("zone");
	String haszone = zone!= null ? "set" : "not-set";
	boolean callback = req.getParameter("callback") != null;
	// Note: I didn't make the url to callback a parameter
	// to not open security holes. (alph)
	// I expect the callback jsp page to be at
	// <zone>/gnujsp/testsuite/callback.jsp
	
	res.setContentType("text/html");
	out.println("<html>");
	out.println("<body>");
	out.println("<h1>GNUJSPTestServlet</h1>");

	String value = "not-set";
	// test if running on gnujsp in jsdk 2.0 engine
	if(req instanceof HttpServletRequestWrapper) {
	    value = (String) ((HttpServletRequestWrapper) req).getAttribute("value");
	} else {
	    value = (String) req.getAttribute("value");
	}
	out.println("[[Value: GNUJSPTestServlet:zone:"+haszone+":"+value+"]]");
	out.println("<br>");

	//System.err.println("Service: request = "+req 
	// +", response="+res);
	
	out.println("uri="+reqURI);
	out.println("<br>");
	
	// FIXME: think about callback stuff
	/*
	if(callback) {
	    Servlet servlet = context.getServlet("gnujsp");
	    servlet.service(request, response);
	}
	*/
	out.println("</body>");
	out.println("</html>");
    }
    public String getServletInfo() {
	return "GNUJSPTestServlet/Carsten Heyl/1.0";
    }
}


