/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jsp;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.gjt.jsp.JspConfig;
import org.gjt.jsp.JspMsg;
import org.gjt.jsp.JspNode;
import org.gjt.jsp.ParseException;

abstract class Emitter
implements JspMsg {
    private static Hashtable concreteEmitters = new Hashtable();

    public static void setEmitter(String string, Emitter emitter) {
        concreteEmitters.put(string.toLowerCase(), emitter);
    }

    public static Emitter getEmitter(String string) {
        return (Emitter)concreteEmitters.get(string.toLowerCase());
    }

    public static void emit(Writer writer, JspNode jspNode) throws IOException {
        Emitter emitter;
        String string = jspNode.getAttribute("language");
        if (string == null) {
            string = "java";
        }
        if ((emitter = Emitter.getEmitter(string)) == null) {
            throw new ParseException(JspConfig.getLocalizedMsg(209) + ": " + string);
        }
        Emitter.emit(emitter, writer, jspNode);
    }

    private static void emit(Emitter emitter, Writer writer, JspNode jspNode) throws IOException {
        if (jspNode == null) {
            return;
        }
        switch (jspNode.getType()) {
            case 1: {
                emitter.emitBeginPage(writer, jspNode);
                Emitter.emit(emitter, writer, jspNode.getFirstChild());
                emitter.emitEndPage(writer, jspNode);
                break;
            }
            case 0: {
                emitter.emitTemplateText(writer, jspNode, jspNode.getAttribute("text"));
                break;
            }
            case 2: {
                emitter.emitBeginPrintExprCall(writer, jspNode);
                emitter.emitPrintExprCall(writer, jspNode, jspNode.getFirstChild().getAttribute("text"));
                emitter.emitEndPrintExprCall(writer);
                break;
            }
            case 3: {
                emitter.emitBeginScriptlet(writer, jspNode);
                emitter.emitScriptlet(writer, jspNode, jspNode.getFirstChild().getAttribute("text"));
                emitter.emitEndScriptlet(writer);
                break;
            }
            case 4: {
                emitter.emitInclude(writer, jspNode, jspNode.getAttribute("page"), jspNode.getAttribute("flush"));
                break;
            }
            case 5: {
                emitter.emitForward(writer, jspNode, jspNode.getAttribute("page"));
                break;
            }
            case 6: {
                emitter.emitBeginUseBean(writer, jspNode, jspNode.getAttribute("id"), jspNode.getAttribute("scope"), jspNode.getAttribute("type"), jspNode.getAttribute("class"), jspNode.getAttribute("beanName"));
                Emitter.emit(emitter, writer, jspNode.getFirstChild());
                emitter.emitEndUseBean(writer);
                break;
            }
            case 7: {
                emitter.emitGetProperty(writer, jspNode, jspNode.getAttribute("name"), jspNode.getAttribute("property"));
                break;
            }
            case 8: {
                emitter.emitSetProperty(writer, jspNode, jspNode.getAttribute("name"), jspNode.getAttribute("property"), jspNode.getAttribute("param"), jspNode.getAttribute("value"));
                break;
            }
        }
        Emitter.emit(emitter, writer, jspNode.getNextSibling());
    }

    abstract void emitBeginPage(Writer var1, JspNode var2) throws IOException;

    abstract void emitEndPage(Writer var1, JspNode var2) throws IOException;

    abstract void emitBeginScriptlet(Writer var1, JspNode var2) throws IOException;

    abstract void emitScriptlet(Writer var1, JspNode var2, String var3) throws IOException;

    abstract void emitEndScriptlet(Writer var1) throws IOException;

    abstract void emitBeginPrintExprCall(Writer var1, JspNode var2) throws IOException;

    abstract void emitPrintExprCall(Writer var1, JspNode var2, String var3) throws IOException;

    abstract void emitEndPrintExprCall(Writer var1) throws IOException;

    abstract void emitTemplateText(Writer var1, JspNode var2, String var3) throws IOException;

    abstract void emitInclude(Writer var1, JspNode var2, String var3, String var4) throws IOException;

    abstract void emitForward(Writer var1, JspNode var2, String var3) throws IOException;

    abstract void emitBeginUseBean(Writer var1, JspNode var2, String var3, String var4, String var5, String var6, String var7) throws IOException;

    abstract void emitEndUseBean(Writer var1) throws IOException;

    abstract void emitGetProperty(Writer var1, JspNode var2, String var3, String var4) throws IOException;

    abstract void emitSetProperty(Writer var1, JspNode var2, String var3, String var4, String var5, String var6) throws IOException;

    Emitter() {
    }
}

