/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The contents of this file are released under an Open Source 
 * Definition (OSD) compliant license; you may not use this file 
 * execpt in compliance with the license. Please see license.txt, 
 * distributed with this file. You may also obtain a copy of the
 * license at http://www.clc-marketing.com/xslp/license.txt
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 *
 * 
 */
 
package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents the xsl:text element
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class XSLText extends XSLObject {
    
    /**
     * The String data of this XSLText 
    **/
    private char[] buffer = null;
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    /**
     * Creates a new XSLText element, with no data
     * @param parentStylesheet the XSL Stylesheet in which this
     * XSLText is to be added
    **/
    public XSLText(XSLStylesheet parentStylesheet) {
        super(parentStylesheet, XSLObject.TEXT);
    } //-- XSLText
    
    /**
     * Creates a new XSLText with the given data
     * @param parentStylesheet the XSL Stylesheet in which this
     * XSLText is to be added
     * @param data the value of this XSLText object
    **/
    public XSLText(XSLStylesheet parentStylesheet,String data) {
        super(parentStylesheet, XSLObject.TEXT);
        appendData(data);
    } //-- XSLText
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Appends the given String to the existing data of
     * this XSLText
     * @param data the String to append
    **/
    public void appendData(String data) {
        if (buffer == null) buffer = data.toCharArray();
        else {
            int size = data.length();
            char[] oldbuffer = buffer;
            buffer = new char[oldbuffer.length+size];
            System.arraycopy(oldbuffer, 0, buffer, 0, oldbuffer.length);
            data.getChars(0, size, buffer, oldbuffer.length);
        }
    } //-- appendData
    
    /**
     * Retrieves the data of this XSLText
     * @return the data of this XSLText
    **/
    public String getData() {
        if (buffer == null) return new String();
        else return new String(buffer);
    } //-- getData
    
    /**
     * Sets the data of this XSLText
     * @param data the String to set the data of this XSLText
     * to.
    **/
    public void setData(String data) {
        buffer = null;
        appendData(data);
    } //--setData
    
} //-- XSLText