/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents an ElementExpr
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class ElementExpr implements NodeExpr {
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    String name = null;
    
    public ElementExpr(String name) {
        super();
        this.name = name;
    } //-- ElementExpr
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    
    /**
     * Returns the String representation of this NodeExpr
    **/
    public String toString() {
        return name;
    } //-- toString
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps)
        throws InvalidExprException 
    {
        NodeSet nodeSet = new NodeSet();
        if (context == null) return nodeSet;
        String nodeName;
        
        NodeList nl = context.getChildNodes();
        for (int i = 0; i < nl.getLength(); i++) {
            Node node = nl.item(i);
            if (matches(node, context, ps)) nodeSet.add(node);
        }
        return nodeSet;
    } //-- evaluate
    
    public short getExprType() { return Expr.NODE_SET; }
    
    
    public String getName() { return this.name; }
        
    /**
     * Returns the type of this NodeExpr
     * @return the type of this NodeExpr
    **/
    public short getNodeExprType() { return NodeExpr.ELEMENT_EXPR; }
    
    
    /**
     * Determines if the given node is matched by this NodeExpr
     * within the given context
    **/
    public boolean matches(Node node, Node context, ProcessorState ps)
        throws InvalidExprException
    {
        if (node == null) return false;
        if (node.getNodeType() == Node.ELEMENT_NODE) {
            String nodeName = node.getNodeName();
            return nodeName.equals(this.name);
        }
        return false;
    } //-- matches
    
} //-- ElementExpr