/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.util;

import com.kvisco.util.List;
import com.kvisco.xsl.util.Token;

public class ExprLexer {
    public static final char FORWARD_SLASH = '/';
    public static final char L_PAREN = '(';
    public static final char R_PAREN = ')';
    public static final char L_BRACKET = '[';
    public static final char R_BRACKET = ']';
    public static final char PERIOD = '.';
    public static final char COMMA = ',';
    public static final char AT_SYMBOL = '@';
    public static final char DOLLAR_SYMBOL = '$';
    public static final char S_QUOTE = '\'';
    public static final char D_QUOTE = '\"';
    public static final char VERT_BAR = '|';
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char EQUALS_OP = '=';
    public static final char ADDITION_OP = '+';
    public static final char SUBTRACTION_OP = '-';
    public static final char LESS_THAN_OP = '<';
    public static final char GREATER_THAN_OP = '>';
    public static final char MULTIPLY_OP = '*';
    private static final char[] delimiters = new char[]{'/', '|', '(', ')', '[', ']', '.', ',', '@', '$', '\'', '\"', ' ', '\t', '\r', '\n', '=', '+', '-', '*', '<', '>'};
    public static final Token[] tokenSet = new Token[]{new Token("and", 301), new Token("or", 302), new Token("mod", 303), new Token("div", 304), new Token("quo", 305), new Token("comment", 202), new Token("pi", 204), new Token("node", 201), new Token("text", 203), new Token("*", 101), new Token("from-ancestors", 601), new Token("from-ancestors-or-self", 602), new Token("from-attributes", 603), new Token("from-children", 604), new Token("from-descendants", 605), new Token("from-descendants-or-self", 606), new Token("from-following", 607), new Token("from-following-siblings", 608), new Token("from-parent", 609), new Token("from-preceding", 610), new Token("from-preceding-siblings", 611), new Token("from-self", 612)};
    private int currentIndex = 0;
    List tokens = null;
    private Token lastToken = new Token(null, 0);

    public ExprLexer(String string) {
        this.tokens = new List();
        this.parse(string);
    }

    private void addToken(Token token) {
        this.tokens.add(token);
        this.lastToken = token;
    }

    public void advance(int n) {
        int n2 = this.currentIndex + n;
        this.currentIndex = n2 >= 0 && n2 < this.tokens.size() ? n2 : this.tokens.size();
    }

    public int countTokens() {
        return this.tokens.size() - this.currentIndex;
    }

    private Token delimiterToken(char c) {
        switch (c) {
            case '/': {
                return new Token(null, 306);
            }
            case '|': {
                return new Token(null, 308);
            }
            case '(': {
                return new Token(null, 1);
            }
            case ')': {
                return new Token(null, 2);
            }
            case '[': {
                return new Token(null, 3);
            }
            case ']': {
                return new Token(null, 4);
            }
            case '.': {
                return new Token(null, 5);
            }
            case ',': {
                return new Token(null, 6);
            }
            case '@': {
                return new Token(null, 7);
            }
            case '=': {
                return new Token(null, 312);
            }
            case '+': {
                return new Token(null, 309);
            }
            case '-': {
                return new Token(null, 310);
            }
            case '*': {
                return new Token(null, 311);
            }
            case '<': {
                return new Token(null, 314);
            }
            case '>': {
                return new Token(null, 315);
            }
        }
        return null;
    }

    private void freeBuffer(StringBuffer stringBuffer, char c) {
        if (stringBuffer.length() > 0) {
            String string = stringBuffer.toString();
            Token token = this.match(string, c);
            if (token != null) {
                this.addToken(token);
            } else {
                this.addToken(new Token(string, 102));
            }
            stringBuffer.setLength(0);
        }
    }

    public int getPosition() {
        return this.currentIndex;
    }

    public boolean hasMoreTokens() {
        return this.countTokens() > 0;
    }

    public static boolean isAdditiveOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 309: 
            case 310: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                return true;
            }
        }
        return false;
    }

    public boolean isDelimiter(char c) {
        int n = 0;
        while (n < delimiters.length) {
            if (c == delimiters[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isEqualityOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 312: 
            case 313: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetter(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isMultiplicativeOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 303: 
            case 304: 
            case 305: 
            case 311: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNCNameChar(char c) {
        if (ExprLexer.isLetter(c)) {
            return true;
        }
        if (ExprLexer.isDigit(c)) {
            return true;
        }
        return c == '.' || c == '_' || c == '-';
    }

    public boolean isOperator(Token token) {
        if (token == null) {
            return false;
        }
        if (ExprLexer.isBinaryOp(token)) {
            return true;
        }
        switch (token.type) {
            case 306: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public static boolean isQNameChar(char c) {
        return ExprLexer.isNCNameChar(c) || c == ':';
    }

    public static boolean isRelationalOp(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public Token lookAhead(int n) {
        int n2 = this.currentIndex + n;
        if (n2 >= 0 && n2 < this.tokens.size()) {
            return (Token)this.tokens.get(n2);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "position() mod 2 = 0";
        System.out.println("Expr: " + string);
        ExprLexer exprLexer = new ExprLexer(string);
        while (exprLexer.hasMoreTokens()) {
            Token token = exprLexer.nextToken();
            String string2 = token.toString();
            System.out.print("TOKEN: " + string2);
            int n = string2.length();
            while (n < 20) {
                System.out.print(" ");
                ++n;
            }
            System.out.println(" type: " + token.type);
        }
    }

    private Token match(String string, char c) {
        if (string == null) {
            return new Token(null, 0);
        }
        int n = 0;
        while (n < tokenSet.length) {
            Token token = tokenSet[n];
            if (token.value.equals(string)) {
                return token;
            }
            ++n;
        }
        return null;
    }

    public Token nextToken() {
        if (this.currentIndex < this.tokens.size()) {
            return (Token)this.tokens.get(this.currentIndex++);
        }
        return null;
    }

    private void parse(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        List list = new List(tokenSet.length);
        int n = 0;
        while (n < tokenSet.length) {
            list.add(tokenSet[n]);
            ++n;
        }
        List list2 = list;
        char c = '\u0000';
        char[] cArray = string.toCharArray();
        char c2 = '\'';
        int n2 = 0;
        block31: while (n2 < cArray.length) {
            char c3 = c;
            c = cArray[n2++];
            if (bl) {
                switch (c) {
                    case '\"': 
                    case '\'': {
                        if (c == c2) {
                            bl = false;
                            this.addToken(new Token(stringBuffer.toString(), 701));
                            stringBuffer.setLength(0);
                            break;
                        }
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (bl2) {
                if (ExprLexer.isDigit(c) || c == '.') {
                    stringBuffer.append(c);
                    continue;
                }
                bl2 = false;
                this.addToken(new Token(stringBuffer.toString(), 401));
                stringBuffer.setLength(0);
                --n2;
                continue;
            }
            if (bl3) {
                if (c == '-') {
                    char c4 = '\u0000';
                    if (n2 < cArray.length) {
                        c4 = cArray[n2];
                    }
                    if (!ExprLexer.isNCNameChar(c4)) {
                        bl3 = false;
                    } else {
                        stringBuffer.append(c);
                    }
                } else if (ExprLexer.isNCNameChar(c)) {
                    stringBuffer.append(c);
                } else {
                    bl3 = false;
                }
                if (bl3) continue;
                this.addToken(new Token(stringBuffer.toString(), 801));
                stringBuffer.setLength(0);
                --n2;
                continue;
            }
            if (this.isDelimiter(c)) {
                Token token = null;
                block3 : switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        this.freeBuffer(stringBuffer, c);
                        break;
                    }
                    case '(': {
                        this.freeBuffer(stringBuffer, c);
                        if (this.lastToken.type == 102) {
                            this.lastToken.type = (short)501;
                        }
                        this.addToken(new Token(null, 1));
                        break;
                    }
                    case ')': {
                        this.freeBuffer(stringBuffer, c);
                        this.addToken(new Token(null, 2));
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        this.freeBuffer(stringBuffer, c);
                        bl = true;
                        c2 = c;
                        break;
                    }
                    case '/': {
                        this.freeBuffer(stringBuffer, c);
                        switch (this.lastToken.type) {
                            case 306: {
                                this.lastToken.type = (short)307;
                                break block3;
                            }
                            case 307: {
                                this.addToken(new Token(null, -1));
                                return;
                            }
                        }
                        this.addToken(new Token(null, 306));
                        break;
                    }
                    case '.': {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(c);
                            break;
                        }
                        switch (this.lastToken.type) {
                            case 802: {
                                this.lastToken.type = (short)803;
                                break block3;
                            }
                            case 803: {
                                this.addToken(new Token(null, -1));
                                return;
                            }
                        }
                        this.addToken(new Token(null, 802));
                        break;
                    }
                    case '$': {
                        this.freeBuffer(stringBuffer, c);
                        bl3 = true;
                        break;
                    }
                    case '@': {
                        this.freeBuffer(stringBuffer, c);
                        this.addToken(new Token("@", 7));
                        break;
                    }
                    case '=': {
                        switch (this.lastToken.type) {
                            case 314: {
                                this.freeBuffer(stringBuffer, c);
                                this.lastToken.type = (short)316;
                                break;
                            }
                            case 315: {
                                this.freeBuffer(stringBuffer, c);
                                this.lastToken.type = (short)317;
                                break;
                            }
                        }
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '<': 
                    case '>': {
                        if (stringBuffer.length() > 0 && c != '-') {
                            this.freeBuffer(stringBuffer, c);
                            this.addToken(this.delimiterToken(c));
                            break;
                        }
                        if (!this.isOperator(this.lastToken)) {
                            switch (this.lastToken.type) {
                                case 0: 
                                case 1: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    stringBuffer.append(c);
                                    break block3;
                                }
                            }
                            this.freeBuffer(stringBuffer, c);
                            this.addToken(this.delimiterToken(c));
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        this.freeBuffer(stringBuffer, c);
                        token = this.delimiterToken(c);
                        if (token == null) continue block31;
                        this.addToken(token);
                        break;
                    }
                }
                continue;
            }
            if (ExprLexer.isDigit(c)) {
                if (stringBuffer.length() == 0 || stringBuffer.length() == 1 && c3 == '-') {
                    bl2 = true;
                    stringBuffer.append(c);
                    continue;
                }
                Token token = this.match(stringBuffer.toString(), c);
                if (token != null && this.isOperator(token)) {
                    this.addToken(token);
                    stringBuffer.setLength(0);
                    stringBuffer.append(c);
                    bl2 = true;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl2) {
            this.addToken(new Token(stringBuffer.toString(), 401));
        } else if (bl) {
            this.addToken(new Token(stringBuffer.toString(), -1));
        } else if (bl3) {
            this.addToken(new Token(stringBuffer.toString(), 801));
        } else {
            this.freeBuffer(stringBuffer, c);
        }
    }

    public void pushBack() {
        if (this.currentIndex > 0) {
            --this.currentIndex;
        }
    }

    public void resetPosition() {
        this.currentIndex = 0;
    }

    public void setPosition(int n) {
        this.currentIndex = n >= 0 && n < this.tokens.size() ? n : (n < 0 ? 0 : this.tokens.size());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.tokens.size()) {
            stringBuffer.append(this.tokens.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }
}

