/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.util.QuickStack;
import com.kvisco.xml.Whitespace;
import com.kvisco.xml.parser.DOMPackage;
import com.kvisco.xsl.AttributeSet;
import com.kvisco.xsl.AttributeValueTemplate;
import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Conditional;
import com.kvisco.xsl.CopyOf;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.ExpressionParser;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.NodeSorter;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.ScriptHandler;
import com.kvisco.xsl.Selection;
import com.kvisco.xsl.TemplateRule;
import com.kvisco.xsl.TreeFragmentResult;
import com.kvisco.xsl.ValueOf;
import com.kvisco.xsl.Variable;
import com.kvisco.xsl.VariableSet;
import com.kvisco.xsl.XSLCData;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLNumber;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.XSLScript;
import com.kvisco.xsl.XSLSort;
import com.kvisco.xsl.XSLStylesheet;
import com.kvisco.xsl.XSLText;
import com.kvisco.xsl.util.MessageObserver;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class RuleProcessor {
    public static final String XSL_VERSION = "version";
    public static final String XSL_VENDOR = "vendor";
    public static final String XSL_VENDOR_URL = "vendor-url";
    private static final String RULE_CONFLICT = "There is a rule conflict between the following two template match expressions:";
    private final String NS_SEP = ":";
    private PrintWriter errorWriter = new PrintWriter(System.out, true);
    private XSLStylesheet stylesheet = null;
    private TemplateRule[] allRules = null;
    private TemplateRule defaultRule = null;
    private Selection selectChildren = null;
    private DOMPackage domPackage = null;
    private Properties xslSysProps = null;
    private StringBuffer errMsgBuffer = null;
    List msgObservers = null;

    public RuleProcessor(XSLStylesheet xSLStylesheet, DOMPackage dOMPackage) {
        this.stylesheet = xSLStylesheet;
        this.domPackage = dOMPackage;
        this.errMsgBuffer = new StringBuffer();
        this.msgObservers = new List(1);
        this.defaultRule = new TemplateRule(xSLStylesheet);
        this.selectChildren = new Selection(xSLStylesheet, 1);
        this.defaultRule.appendAction(this.selectChildren);
        this.xslSysProps = new Properties();
        ((Hashtable)this.xslSysProps).put(XSL_VERSION, "1.0");
        ((Hashtable)this.xslSysProps).put(XSL_VENDOR, "XSL:P Open Software Group");
        ((Hashtable)this.xslSysProps).put(XSL_VENDOR_URL, "http://xslp.kvisco.com");
        this.allRules = xSLStylesheet.getTemplates();
    }

    private void addIDReferences(Element element, Hashtable hashtable, Hashtable hashtable2) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)hashtable.get(string2);
                    if (!string3.equals("*") && !string3.equals(element2.getNodeName()) || (string = element2.getAttribute(string2)) == null || string.length() <= 0) continue;
                    if (hashtable2.get(string) != null) {
                        this.errorWriter.print("warning: multiple elements with the same id value: ");
                        this.errorWriter.println(string);
                        this.errorWriter.println(" -- processing will continue with first occurance only.");
                        continue;
                    }
                    hashtable2.put(string, element2);
                }
                this.addIDReferences(element2, hashtable, hashtable2);
            }
            ++n;
        }
    }

    public void addMessageObserver(MessageObserver messageObserver) {
        this.msgObservers.add(messageObserver);
    }

    protected void bindVariable(Variable variable, Node node, ProcessorState processorState) {
        VariableSet variableSet;
        VariableSet variableSet2 = (VariableSet)processorState.getVariableSets().peek();
        ExprResult exprResult = null;
        if (variable.getType() == 27 && (variableSet = (VariableSet)processorState.getParameterStack().peek()) != null) {
            exprResult = variableSet.get(variable.getName());
        }
        if (exprResult == null) {
            exprResult = this.processVariable(variable, node, processorState);
        }
        if (exprResult != null) {
            variableSet2.put(variable.getName(), exprResult);
        }
    }

    private Node copyNode(Document document, Node node, boolean bl) {
        Node node2 = null;
        switch (node.getNodeType()) {
            case 2: {
                Attr attr = (Attr)node;
                node2 = document.createAttribute(attr.getName());
                ((Attr)node2).setValue(attr.getValue());
                break;
            }
            case 4: {
                String string = ((CharacterData)node).getData();
                node2 = document.createCDATASection(string);
                break;
            }
            case 8: {
                String string = ((CharacterData)node).getData();
                node2 = document.createComment(string);
                break;
            }
            case 11: {
                node2 = document.createDocumentFragment();
                if (!bl) break;
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node3 = this.copyNode(document, nodeList.item(n), bl);
                    node2.appendChild(node3);
                    ++n;
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                node2 = document.createElement(element.getNodeName());
                if (!bl) break;
                Element element2 = (Element)node2;
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap != null) {
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        Attr attr = (Attr)namedNodeMap.item(n);
                        element2.setAttribute(attr.getName(), attr.getValue());
                        ++n;
                    }
                }
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node4 = this.copyNode(document, nodeList.item(n), bl);
                    node2.appendChild(node4);
                    ++n;
                }
                break;
            }
            case 5: {
                node2 = document.createEntityReference(node.getNodeName());
                break;
            }
            case 3: {
                String string = ((CharacterData)node).getData();
                node2 = document.createTextNode(string);
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                node2 = document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
        }
        return node2;
    }

    private Node createNode(Node node, XSLObject xSLObject, ProcessorState processorState) throws XSLException {
        Element element;
        Document document = processorState.getResultDocument();
        QuickStack quickStack = processorState.getNodeStack();
        String string = null;
        String string2 = null;
        Node node2 = null;
        AttributeValueTemplate attributeValueTemplate = null;
        attributeValueTemplate = xSLObject.getAttributeAsAVT("name");
        string = attributeValueTemplate != null ? attributeValueTemplate.evaluate(node, processorState) : "";
        short s = xSLObject.getType();
        if (s != 10 || s != 12) {
            element = document.createElement(xSLObject.getTypeName());
            quickStack.push(element);
            this.processTemplate(node, xSLObject.getActions(), processorState);
            quickStack.pop();
            string2 = XSLObject.getText(element);
        }
        switch (s) {
            case 3: {
                node2 = (Node)quickStack.peek();
                if (node2.getNodeType() != 1) break;
                element = (Element)node2;
                if (element.hasChildNodes()) {
                    return null;
                }
                string2 = Whitespace.stripSpace(string2);
                node2 = document.createAttribute(string);
                ((Attr)node2).setValue(string2);
                break;
            }
            case 8: {
                node2 = document.createComment(string2);
                break;
            }
            case 10: {
                node2 = this.copyNode(document, node, false);
                if (node2.getNodeType() != 1) break;
                quickStack.push(node2);
                this.processTemplate(node, xSLObject.getActions(), processorState);
                quickStack.pop();
                break;
            }
            case 12: {
                node2 = document.createElement(string);
                quickStack.push(node2);
                this.processTemplate(node, xSLObject.getActions(), processorState);
                quickStack.pop();
                break;
            }
            case 39: {
                node2 = document.createEntityReference(string);
                break;
            }
            case 28: {
                node2 = document.createProcessingInstruction(string, string2);
                break;
            }
        }
        return node2;
    }

    protected TemplateRule findTemplate(TemplateRule[] templateRuleArray, Node node, String string, ProcessorState processorState) throws InvalidExprException, XSLException {
        TemplateRule templateRule = null;
        int n = 0;
        while (n < templateRuleArray.length) {
            String string2;
            TemplateRule templateRule2 = templateRuleArray[n];
            if (!(!templateRule2.matches(node, node, processorState) || (string2 = templateRule2.getMode()) == null && string != null || string2 != null && string == null || string2 != null && string != null && !string2.equals(string))) {
                if (templateRule == null) {
                    templateRule = templateRule2;
                } else {
                    float f;
                    float f2 = templateRule.calculatePriority(node, processorState);
                    if (f2 < (f = templateRule2.calculatePriority(node, processorState))) {
                        templateRule = templateRule2;
                    } else if (f2 == f) {
                        if (templateRule.getParentStylesheet() == templateRule2.getParentStylesheet()) {
                            StringBuffer stringBuffer = new StringBuffer(RULE_CONFLICT);
                            stringBuffer.append("\n 1." + templateRule.getMatchExpr());
                            stringBuffer.append(" mode='" + templateRule.getMode() + "' {");
                            stringBuffer.append(templateRule.getParentStylesheet().getHref());
                            stringBuffer.append("}\n 2." + templateRule2.getMatchExpr());
                            stringBuffer.append(" mode='" + templateRule2.getMode() + "' {");
                            stringBuffer.append(templateRule2.getParentStylesheet().getHref());
                            stringBuffer.append("}\n");
                            throw new XSLException(stringBuffer.toString());
                        }
                        templateRule = templateRule2;
                    }
                }
            }
            ++n;
        }
        return templateRule;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public String getProperty(String string) {
        return this.xslSysProps.getProperty(string, "");
    }

    private String getResolvedName(String string) {
        int n = 0;
        n = string.indexOf(":");
        if (n > 0) {
            String string2 = this.stylesheet.getQuotedNamespace(string.substring(0, n));
            return String.valueOf(string2) + string.substring(n);
        }
        return string;
    }

    private boolean isStripSpaceAllowed(Node node, ProcessorState processorState) {
        if (node == null) {
            return true;
        }
        if (processorState.getXMLSpaceModes().peek() == "preserve") {
            return false;
        }
        Node node2 = node;
        switch (node.getNodeType()) {
            case 9: {
                return true;
            }
            default: {
                node2 = node.getParentNode();
                if (node2 == null) {
                    return false;
                }
                if (node2.getNodeType() == 1) break;
                return true;
            }
            case 1: 
        }
        return this.stylesheet.isStripSpaceAllowed(node2.getNodeName());
    }

    public Document process(Document document) {
        if (document == null) {
            this.errorWriter.println("Null document, returning empty result");
            return this.domPackage.createDocument();
        }
        Hashtable hashtable = new Hashtable(200, 0.5f);
        Element element = document.getDocumentElement();
        if (element != null) {
            this.addIDReferences(element, this.stylesheet.getIds(), hashtable);
        }
        return this.process(document, hashtable);
    }

    protected Document process(Document document, Hashtable hashtable) {
        if (document == null) {
            return this.domPackage.createDocument();
        }
        ProcessorState processorState = new ProcessorState(this, document, this.stylesheet, this.domPackage);
        processorState.setIDReferences(hashtable);
        Document document2 = processorState.getResultDocument();
        QuickStack quickStack = processorState.getNodeStack();
        List list = this.stylesheet.getScripts();
        ScriptHandler scriptHandler = null;
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < list.size()) {
            XSLScript xSLScript = (XSLScript)list.get(n);
            string = xSLScript.getAttribute("language");
            scriptHandler = processorState.getScriptHandler(string);
            if (scriptHandler != null) {
                Object object;
                string2 = xSLScript.getAttribute("ns");
                if (string2 != null) {
                    scriptHandler.createNamespace(string2);
                }
                if ((object = scriptHandler.eval(xSLScript, document, string2)) != null) {
                    this.errorWriter.print(object);
                }
            }
            ++n;
        }
        TemplateRule templateRule = null;
        try {
            templateRule = this.findTemplate(this.allRules, document, null, processorState);
        }
        catch (Exception exception) {
            this.errorWriter.println(exception.getMessage());
            this.errorWriter.flush();
        }
        try {
            if (templateRule != null) {
                this.processTemplate(document, templateRule.getActions(), processorState);
            } else {
                this.processTemplate(document, this.defaultRule.getActions(), processorState);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.errorWriter);
        }
        return document2;
    }

    private void processAction(XSLObject xSLObject, Node node, NodeList nodeList, ProcessorState processorState) {
        Document document = processorState.getResultDocument();
        QuickStack quickStack = processorState.getNodeStack();
        Hashtable hashtable = processorState.getIDReferences();
        Element element = null;
        Node node2 = null;
        Object var10_10 = null;
        String string = null;
        String string2 = null;
        Object var13_13 = null;
        TemplateRule[] templateRuleArray = this.allRules;
        NodeSet nodeSet = null;
        block7 : switch (xSLObject.getType()) {
            case 0: {
                templateRuleArray = xSLObject.getParentStylesheet().getTemplates();
            }
            case 1: {
                XSLSort[] xSLSortArray;
                Selection selection = (Selection)xSLObject;
                VariableSet variableSet = this.processParameters(xSLObject, node, processorState);
                try {
                    nodeSet = selection.selectNodes(node, processorState);
                }
                catch (InvalidExprException invalidExprException) {
                    this.errorWriter.println(invalidExprException.getMessage());
                    this.errorWriter.flush();
                    break;
                }
                if (nodeSet.size() > 0 && (xSLSortArray = selection.getSortElements()).length > 0) {
                    nodeSet = NodeSorter.sort(nodeSet, xSLSortArray, node, processorState);
                }
                xSLSortArray = selection.getAttribute("mode");
                processorState.getParameterStack().push(variableSet);
                processorState.getNodeSetStack().push(nodeSet);
                int n = 0;
                while (n < nodeSet.size()) {
                    node2 = nodeSet.get(n);
                    List list = null;
                    TemplateRule templateRule = null;
                    try {
                        templateRule = this.findTemplate(templateRuleArray, node2, (String)xSLSortArray, processorState);
                    }
                    catch (Exception exception) {
                        this.errorWriter.print("error finding template: ");
                        this.errorWriter.println(exception);
                        this.errorWriter.flush();
                    }
                    if (templateRule != null) {
                        list = templateRule.getActions();
                    }
                    if (node2 != node) {
                        this.processTemplate(node2, list, processorState);
                    } else {
                        XSLObject xSLObject2 = selection.getNearestAncestor((short)33);
                        if (templateRule != xSLObject2) {
                            this.processTemplate(node2, templateRule.getActions(), processorState);
                        }
                    }
                    ++n;
                }
                processorState.getParameterStack().pop();
                processorState.getNodeSetStack().pop();
                break;
            }
            case 5: {
                VariableSet variableSet = this.processParameters(xSLObject, node, processorState);
                processorState.getParameterStack().push(variableSet);
                string = xSLObject.getAttribute("name");
                TemplateRule templateRule = this.stylesheet.getNamedTemplate(string);
                if (templateRule != null) {
                    this.processTemplate(node, templateRule.getActions(), processorState);
                } else {
                    this.errorWriter.print("No named template found: ");
                    this.errorWriter.println(string);
                }
                processorState.getParameterStack().pop();
                break;
            }
            case 13: {
                XSLSort[] xSLSortArray;
                Selection selection = (Selection)xSLObject;
                try {
                    nodeSet = selection.selectNodes(node, processorState);
                }
                catch (InvalidExprException invalidExprException) {
                    this.errorWriter.print(invalidExprException.getMessage());
                    break;
                }
                if (nodeSet.size() > 0 && (xSLSortArray = selection.getSortElements()).length > 0) {
                    nodeSet = NodeSorter.sort(nodeSet, xSLSortArray, node, processorState);
                }
                processorState.getNodeSetStack().push(nodeSet);
                int n = 0;
                while (n < nodeSet.size()) {
                    node2 = nodeSet.get(n);
                    if (node2 != node) {
                        this.processTemplate(node2, selection.getActions(), processorState);
                    }
                    ++n;
                }
                processorState.getNodeSetStack().pop();
                break;
            }
            case 16: {
                Conditional conditional = (Conditional)((Object)xSLObject);
                BooleanResult booleanResult = null;
                try {
                    booleanResult = conditional.evaluate(node, processorState);
                }
                catch (InvalidExprException invalidExprException) {
                    this.errorWriter.print(invalidExprException.getMessage());
                    break;
                }
                if (!booleanResult.booleanValue()) break;
                this.processTemplate(node, xSLObject.getActions(), processorState);
                break;
            }
            case 7: {
                List list = xSLObject.getActions();
                BooleanResult booleanResult = null;
                int n = 0;
                while (n < list.size()) {
                    XSLObject xSLObject3 = (XSLObject)list.get(n);
                    Conditional conditional = (Conditional)((Object)xSLObject3);
                    try {
                        booleanResult = conditional.evaluate(node, processorState);
                    }
                    catch (InvalidExprException invalidExprException) {
                        this.errorWriter.print(invalidExprException.getMessage());
                        break block7;
                    }
                    if (booleanResult.booleanValue()) {
                        this.processTemplate(node, xSLObject3.getActions(), processorState);
                        break block7;
                    }
                    ++n;
                }
                break;
            }
            case 22: {
                DocumentFragment documentFragment = document.createDocumentFragment();
                quickStack.push(documentFragment);
                this.processTemplate(node, xSLObject.getActions(), processorState);
                quickStack.pop();
                string2 = XSLObject.getNodeValue(documentFragment);
                int n = 0;
                while (n < this.msgObservers.size()) {
                    ((MessageObserver)this.msgObservers.get(n)).recieveMessage(string2);
                    ++n;
                }
                break;
            }
            case 23: {
                this.processXSLNumber((Element)node, (XSLNumber)xSLObject, processorState);
                break;
            }
            case 36: {
                string2 = ((ValueOf)xSLObject).getValue(node, processorState);
                if (this.isStripSpaceAllowed(node, processorState)) {
                    string2 = Whitespace.stripSpace(string2, true, true);
                }
                if (string2 != null && string2.length() > 0) {
                    processorState.addToResultTree(document.createTextNode(string2));
                }
                string2 = null;
                break;
            }
            case 27: 
            case 37: {
                this.bindVariable((Variable)xSLObject, node, processorState);
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 28: 
            case 39: {
                try {
                    node2 = this.createNode(node, xSLObject, processorState);
                    if (node2 == null) break;
                    processorState.addToResultTree(node2);
                }
                catch (XSLException xSLException) {
                    this.errorWriter.println(xSLException);
                }
                break;
            }
            case 11: {
                CopyOf copyOf = (CopyOf)xSLObject;
                try {
                    NodeSet nodeSet2 = copyOf.selectNodes(node, processorState);
                    int n = 0;
                    while (n < nodeSet2.size()) {
                        node2 = this.copyNode(document, nodeSet2.get(n), true);
                        processorState.addToResultTree(node2);
                        ++n;
                    }
                }
                catch (InvalidExprException invalidExprException) {
                    this.errorWriter.println(invalidExprException);
                }
                break;
            }
            case 34: {
                String string3 = ((XSLText)xSLObject).getData();
                processorState.addToResultTree(document.createTextNode(string3));
                break;
            }
            case 6: {
                String string4 = ((XSLCData)xSLObject).getData();
                processorState.addToResultTree(document.createCDATASection(string4));
                break;
            }
            case 35: {
                AttributeSet attributeSet;
                string = xSLObject.getAttribute("attribute-set");
                if (string == null || string.length() <= 0 || (attributeSet = this.stylesheet.getAttributeSet(string)) == null) break;
                this.processTemplate((Node)quickStack.peek(), attributeSet.getActions(), processorState);
                break;
            }
            case 40: {
                XSLScript xSLScript = (XSLScript)xSLObject;
                String string5 = xSLScript.getAttribute("language");
                ScriptHandler scriptHandler = processorState.getScriptHandler(string5);
                if (scriptHandler != null) {
                    Object object = scriptHandler.evalAsFunction(xSLScript, node);
                    if (object == null) break;
                    processorState.addToResultTree(document.createCDATASection(object.toString()));
                    break;
                }
                this.errorWriter.print("Warning no ScriptHandler found for language: ");
                this.errorWriter.println(string5);
                this.errorWriter.flush();
                break;
            }
            case 20: {
                string = this.getResolvedName(xSLObject.getTypeName());
                element = document.createElement(string);
                processorState.addToResultTree(element);
                quickStack.push(element);
                this.processAttributes(xSLObject, node, processorState);
                this.processTemplate(node, xSLObject.getActions(), processorState);
                quickStack.pop();
                break;
            }
        }
    }

    private void processAttributes(XSLObject xSLObject, Node node, ProcessorState processorState) {
        Node node2 = (Node)processorState.getNodeStack().peek();
        if (node2.getNodeType() != 1) {
            return;
        }
        Element element = (Element)node2;
        Enumeration enumeration = xSLObject.getAttributeNames();
        AttributeValueTemplate attributeValueTemplate = null;
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            try {
                attributeValueTemplate = xSLObject.getAttributeAsAVT(string2);
            }
            catch (XSLException xSLException) {
                attributeValueTemplate = null;
            }
            if (attributeValueTemplate != null) {
                string = attributeValueTemplate.evaluate(node, processorState);
                string = Whitespace.stripSpace(string, true, true);
            } else {
                string = "";
            }
            element.setAttribute(string2, string);
        }
    }

    private VariableSet processParameters(XSLObject xSLObject, Node node, ProcessorState processorState) {
        VariableSet variableSet = new VariableSet();
        List list = xSLObject.getActions();
        int n = 0;
        while (n < list.size()) {
            XSLObject xSLObject2 = (XSLObject)list.get(n);
            if (xSLObject2.getType() == 26) {
                Variable variable = (Variable)xSLObject2;
                variableSet.put(variable.getName(), this.processVariable(variable, node, processorState));
            }
            ++n;
        }
        return variableSet;
    }

    private void processTemplate(Node node, List list, ProcessorState processorState) {
        Object object;
        if (node.getNodeType() == 1 && (object = ((Element)node).getAttribute("xml:space")) != null && ((String)object).length() > 0) {
            processorState.getXMLSpaceModes().push(((String)object).intern());
        }
        if (list != null) {
            object = processorState.getVariableSets();
            ((QuickStack)object).push(new VariableSet(5));
            int n = 0;
            while (n < list.size()) {
                XSLObject xSLObject = (XSLObject)list.get(n);
                this.processAction(xSLObject, node, null, processorState);
                ++n;
            }
            ((QuickStack)object).pop();
        } else {
            if (node == null) {
                return;
            }
            switch (node.getNodeType()) {
                case 1: {
                    this.processAction(this.selectChildren, node, null, processorState);
                    break;
                }
                case 4: {
                    object = ((Text)node).getData();
                    Document document = processorState.getResultDocument();
                    CDATASection cDATASection = document.createCDATASection((String)object);
                    processorState.addToResultTree(cDATASection);
                    break;
                }
                case 3: {
                    object = this.isStripSpaceAllowed(node, processorState) ? this.stripSpace((Text)node) : ((Text)node).getData();
                    if (object == null || ((String)object).length() <= 0) break;
                    Document document = processorState.getResultDocument();
                    Text text = document.createTextNode((String)object);
                    processorState.addToResultTree(text);
                    break;
                }
            }
        }
    }

    protected ExprResult processVariable(Variable variable, Node node, ProcessorState processorState) {
        QuickStack quickStack = processorState.getNodeStack();
        Document document = processorState.getResultDocument();
        String string = variable.getAttribute("expr");
        ExprResult exprResult = null;
        if (string != null && string.length() > 0) {
            try {
                Expr expr = ExpressionParser.createExpr(string);
                exprResult = expr.evaluate(node, processorState);
            }
            catch (InvalidExprException invalidExprException) {
                this.errMsgBuffer.setLength(0);
                this.errMsgBuffer.append("variable binding error: '");
                this.errMsgBuffer.append(variable.getName());
                this.errMsgBuffer.append("' - ");
                this.errMsgBuffer.append(invalidExprException.getMessage());
                this.errorWriter.println(this.errMsgBuffer.toString());
            }
        } else {
            DocumentFragment documentFragment = document.createDocumentFragment();
            quickStack.push(documentFragment);
            List list = variable.getActions();
            this.processTemplate(node, variable.getActions(), processorState);
            quickStack.pop();
            NodeList nodeList = documentFragment.getChildNodes();
            exprResult = nodeList.getLength() == 1 ? new TreeFragmentResult(nodeList.item(0)) : new TreeFragmentResult(documentFragment);
        }
        return exprResult;
    }

    private void processXSLNumber(Element element, XSLNumber xSLNumber, ProcessorState processorState) {
        String string = xSLNumber.getFormattedNumber(element, processorState);
        processorState.addToResultTree(processorState.getResultDocument().createTextNode(string));
    }

    public MessageObserver removeMessageObserver(MessageObserver messageObserver) {
        if (this.msgObservers.remove(messageObserver)) {
            return messageObserver;
        }
        return null;
    }

    public void setErrorWriter(OutputStream outputStream) {
        this.errorWriter = new PrintWriter(outputStream, true);
    }

    public void setErrorWriter(Writer writer) {
        this.errorWriter = new PrintWriter(writer, true);
    }

    private String stripSpace(Text text) {
        boolean bl = text.getPreviousSibling() == null;
        boolean bl2 = text.getNextSibling() == null;
        return Whitespace.stripSpace(text.getData(), bl, bl2);
    }
}

