/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class PIExpr
implements NodeExpr {
    String target = null;

    public PIExpr(String string) {
        this.target = string;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (this.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            ++n;
        }
        return nodeSet;
    }

    public short getExprType() {
        return 1;
    }

    public short getNodeExprType() {
        return 8;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() == 7) {
            String string = ((ProcessingInstruction)node).getTarget();
            if (this.target == null) {
                return true;
            }
            return this.target.equals(string);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pi");
        stringBuffer.append("(");
        if (this.target != null) {
            stringBuffer.append(this.target);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

