/**
 * The contents of this file are subject to the OpenXML Public
 * License Version 1.0; you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.openxml.org/license/
 *
 * THIS SOFTWARE AND DOCUMENTATION IS PROVIDED ON AN "AS IS" BASIS
 * WITHOUT WARRANTY OF ANY KIND EITHER EXPRESSED OR IMPLIED,
 * INCLUDING AND WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE
 * AND DOCUMENTATION IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGING. SEE THE LICENSE FOR THE
 * SPECIFIC LANGUAGE GOVERNING RIGHTS AND LIMITATIONS UNDER THE
 * LICENSE.
 *
 * The Initial Developer of this code under the License is
 * OpenXML.org. Portions created by OpenXML.org and/or Assaf Arkin
 * are Copyright (C) 1998, 1999 OpenXML.org. All Rights Reserved.
 */


package examples;


import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import org.openxml.*;
import org.openxml.io.*;
import org.openxml.x3p.*;
import org.openxml.util.*;


/**
 * This example parses an XML document (ex1.xml), prints that document in
 * the XHTML format (output.xhtml), lists the contents of the document
 * and prints the last error reported by the parser. It is mainly used
 * to demonstrating parsing, publishing and looking at the document tree
 * and as the basis for creating others examples.
 * 
 * 
 * @version $Revision: 1.2 $ $Date: 1999/04/18 01:48:28 $
 * @author <a href="mailto:arkin@trendline.co.il">Assaf Arkin</a>
 */
public class Ex1
{


    public static void main( String args[] )
    {
        try
        {
            Parser          parser;
            InputStream     is;
            Document        doc;
            Publisher       pub;
            StreamFormat    format;

            is = new FileInputStream( "examples/ex1.xml" );
            parser = DOMFactory.createParser( is, null, null );
            doc = parser.parseDocument();

            format = StreamFormat.XHTML_PRETTY.changeLineWrap(80);
            pub = PublisherFactory.createPublisher( new File( "examples/output.xhtml" ), format );
            pub.publish( doc );
            pub.close();

            if ( parser.getLastException() != null )
            {
                System.out.println( parser.getLastException().getSystemId() + ":" +
                parser.getLastException().getLineNumber() + ": " +
                parser.getLastException().getMessage() );
            }

            list( doc );
        }
        catch ( Exception except )
        {
            System.out.println( except );
            except.printStackTrace( System.err );
        }
    }


    static void list( Node node )
    {
        while ( node != null )
        {
            System.out.println( "Node name [" + node.getNodeName() + "] value [" + node.getNodeValue() + "]" );
            if ( node.hasChildNodes() )
                list( node.getFirstChild() );
            node = node.getNextSibling();
        }
    }


}

