/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import org.openxml.dom.AttrImpl;
import org.openxml.dom.AttrNodeMap;
import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.DocumentImpl;
import org.openxml.dom.NodeImpl;
import org.openxml.dom.TextImpl;
import org.openxml.dom.iterator.ElementTagFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementImpl
extends NodeImpl
implements Element {
    AttrImpl _firstAttr;
    AttrImpl _lastAttr;
    int _attrCount;
    private AttrNodeMap _attrNodeMap;

    public ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null, true);
    }

    private final synchronized AttrImpl appendAttr(AttrImpl attrImpl) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (attrImpl == null) {
            throw new DOMExceptionImpl(4, "Attribute does not belong to same document as this element.");
        }
        if (attrImpl._parent == this) {
            return attrImpl;
        }
        if (attrImpl._parent != null) {
            throw new DOMExceptionImpl(10);
        }
        AttrImpl attrImpl2 = attrImpl;
        synchronized (attrImpl2) {
            attrImpl._parent = this;
            attrImpl.setOwnerDocument(this.getOwnerDocument());
            if (this._lastAttr == null) {
                this._lastAttr = attrImpl;
                this._firstAttr = attrImpl;
                attrImpl._prevNode = null;
                attrImpl._nextNode = null;
            } else {
                this._lastAttr._nextNode = attrImpl;
                attrImpl._prevNode = this._lastAttr;
                attrImpl._nextNode = null;
                this._lastAttr = attrImpl;
            }
            ++this._attrCount;
        }
        return attrImpl;
    }

    public final Object clone() {
        ElementImpl elementImpl = (ElementImpl)this._ownerDocument.createElement(this.getNodeName());
        this.cloneInto(elementImpl, true);
        return elementImpl;
    }

    protected synchronized void cloneInto(NodeImpl nodeImpl, boolean bl) {
        super.cloneInto(nodeImpl, bl);
        ElementImpl elementImpl = (ElementImpl)nodeImpl;
        elementImpl._firstAttr = null;
        elementImpl._lastAttr = null;
        elementImpl._attrCount = 0;
        AttrImpl attrImpl = this._firstAttr;
        while (attrImpl != null) {
            elementImpl.appendAttr((AttrImpl)attrImpl.cloneNode(true));
            attrImpl = (AttrImpl)attrImpl._nextNode;
        }
    }

    public final Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)this._ownerDocument.createElement(this.getNodeName());
        this.cloneInto(elementImpl, bl);
        return elementImpl;
    }

    public synchronized boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ElementImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Object object2 = object;
        synchronized (object2) {
            ElementImpl elementImpl = (ElementImpl)object;
            boolean bl2 = bl = this._attrCount == elementImpl._attrCount;
            if (bl) {
                AttrImpl attrImpl = this._firstAttr;
                while (bl && attrImpl != null) {
                    bl = elementImpl.getNamedAttr(attrImpl.getNodeName()) != null && elementImpl.getNamedAttr(attrImpl.getNodeName()).equals(attrImpl);
                    attrImpl = (AttrImpl)attrImpl._nextNode;
                }
            }
        }
        return bl;
    }

    public final synchronized String getAttribute(String string) {
        AttrImpl attrImpl = this.getNamedAttr(string);
        if (attrImpl == null) {
            return null;
        }
        return attrImpl.getValue();
    }

    public final Attr getAttributeNode(String string) {
        return this.getNamedAttr(string);
    }

    public final synchronized NamedNodeMap getAttributes() {
        if (this._attrNodeMap == null) {
            this._attrNodeMap = new AttrNodeMap(this);
        }
        return this._attrNodeMap;
    }

    public final NodeList getElementsByTagName(String string) {
        return (NodeList)((Object)this.createTreeIterator(2, ElementTagFilter.lookup(string)));
    }

    final AttrImpl getNamedAttr(String string) {
        AttrImpl attrImpl = this._firstAttr;
        while (attrImpl != null) {
            if (attrImpl.getName().equals(string)) {
                return attrImpl;
            }
            attrImpl = (AttrImpl)attrImpl._nextNode;
        }
        return null;
    }

    public final short getNodeType() {
        return 1;
    }

    public final String getTagName() {
        return this.getNodeName();
    }

    public final synchronized void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof ElementImpl) {
                ((ElementImpl)node).normalize();
            } else if (node instanceof TextImpl) {
                Node node2 = node.getNextSibling();
                while (node2 != null && node2 instanceof TextImpl) {
                    ((TextImpl)node).appendData(((TextImpl)node2).getData());
                    this.removeChild(node2);
                    node2 = node.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
    }

    final AttrImpl removeAttr(AttrImpl attrImpl) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (attrImpl == null || attrImpl._parent != this) {
            throw new DOMExceptionImpl(8, "Not an attribute of this element.");
        }
        AttrImpl attrImpl2 = attrImpl;
        synchronized (attrImpl2) {
            attrImpl._parent = null;
            if (this._firstAttr == attrImpl) {
                this._firstAttr = (AttrImpl)attrImpl._nextNode;
            }
            if (this._lastAttr == attrImpl) {
                this._lastAttr = (AttrImpl)attrImpl._prevNode;
            }
            if (attrImpl._prevNode != null) {
                attrImpl._prevNode._nextNode = attrImpl._nextNode;
            }
            if (attrImpl._nextNode != null) {
                attrImpl._nextNode._prevNode = attrImpl._prevNode;
            }
            attrImpl._prevNode = null;
            attrImpl._nextNode = null;
            --this._attrCount;
        }
        return attrImpl;
    }

    public final synchronized void removeAttribute(String string) {
        AttrImpl attrImpl = this.getNamedAttr(string);
        if (attrImpl != null) {
            this.removeAttr(attrImpl);
        }
    }

    public final synchronized Attr removeAttributeNode(Attr attr) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (!(attr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(3, "Node is not an attribute compatible with this element.");
        }
        if ((attr = this.removeAttr((AttrImpl)attr)) == null) {
            throw new DOMExceptionImpl(8);
        }
        return attr;
    }

    public final synchronized void setAttribute(String string, String string2) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (string2 == null) {
            this.removeAttribute(string);
        } else {
            AttrImpl attrImpl = this.getNamedAttr(string);
            if (attrImpl == null) {
                attrImpl = new AttrImpl(this._ownerDocument, string, "");
                this.appendAttr(attrImpl);
            }
            attrImpl.setValue(string2);
        }
    }

    public final synchronized Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl;
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (attr == null || !(attr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(4);
        }
        if (((AttrImpl)attr)._parent != null) {
            throw new DOMExceptionImpl(10);
        }
        Attr attr2 = attr;
        synchronized (attr2) {
            attrImpl = this.getNamedAttr(attr.getName());
            if (attrImpl != null) {
                this.removeAttr(attrImpl);
            }
            this.appendAttr((AttrImpl)attr);
        }
        return attrImpl;
    }

    public final void setNodeValue(String string) {
        throw new DOMExceptionImpl(6, "This node type does not support values.");
    }

    protected boolean supportsChildern() {
        return true;
    }

    public String toString() {
        String string = this.getTagName();
        if (string.length() > 32) {
            string = String.valueOf(string.substring(0, 32)) + "..";
        }
        return "Element node: [" + string + "] (" + this.getChildCount() + " nodes, " + this._attrCount + " attrs)";
    }
}

