/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.publishers;

import java.io.IOException;
import org.openxml.x3p.publishers.HTMLEntities;
import org.openxml.x3p.publishers.StreamPublisher;
import org.openxml.x3p.publishers.StreamPublisherTarget;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLPreElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLStyleElement;

public final class XHTMLStreamPublisher
extends StreamPublisher {
    XHTMLStreamPublisher(StreamPublisherTarget streamPublisherTarget) throws IOException {
        super(streamPublisherTarget);
    }

    protected String getCharacterRef(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '&': {
                return "amp";
            }
        }
        return HTMLEntities.fromChar(c);
    }

    protected void printElement(Element element, StringBuffer stringBuffer, boolean bl) throws IOException {
        stringBuffer.append("<").append(element.getTagName().toLowerCase());
        this.printPart(stringBuffer);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.printSpace();
            stringBuffer.setLength(0);
            stringBuffer.append(attr.getName().toLowerCase());
            stringBuffer.append("=\"");
            if (attr.getValue() != null) {
                stringBuffer.append(this.encode(attr.getValue(), false));
            }
            stringBuffer.append('\"');
            this.printPart(stringBuffer);
            ++n;
        }
        if (element.hasChildNodes() || HTMLEntities.supportsChildren(element.getTagName())) {
            this.printPart(">");
            this.indent();
            if (element instanceof HTMLScriptElement || element instanceof HTMLStyleElement) {
                bl = true;
                this.printPart("<![CDATA[");
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                }
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node instanceof CharacterData) {
                        this.printPart(((CharacterData)node).getData());
                    }
                    node = node.getNextSibling();
                }
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                }
                this.printPart("]]>");
            } else {
                Node node = element.getFirstChild();
                boolean bl2 = true;
                boolean bl3 = false;
                while (node != null) {
                    if (node instanceof Element) {
                        if (element instanceof HTMLPreElement) {
                            this.breakLine();
                            bl3 = true;
                            this.printNode(node, bl);
                            this.breakLine();
                        } else if (this.getFormat().isPretty() && bl2) {
                            this.breakLine();
                            bl3 = true;
                            this.printNode(node, bl);
                            this.breakLine();
                        } else {
                            this.printNode(node, bl);
                        }
                        bl2 = true;
                    } else if (this.printNode(node, bl)) {
                        bl2 = true;
                        bl3 = true;
                    }
                    node = node.getNextSibling();
                }
                if (bl2 && bl3) {
                    this.breakLine();
                }
            }
            stringBuffer.setLength(0);
            this.unindent();
            stringBuffer.append("</").append(element.getTagName().toLowerCase()).append('>');
            this.printPart(stringBuffer);
        } else {
            this.printPart(" />");
        }
    }

    public synchronized void publish(Document document) throws IOException {
        this.printPart("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
        this.breakLine();
        this.printPart("                      \"http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd\">");
        this.breakLine();
        Element element = (Element)document.getElementsByTagName("html").item(0);
        if (element == null) {
            element = (Element)document.getElementsByTagName("HTML").item(0);
        }
        if (element != null) {
            element.setAttribute("xmlns", "http://www.w3.org/Profiles/xhtml1-strict");
        }
        this.publish((Node)document);
        this.flush();
    }
}

