/* 
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	runxanim.c

	routines to execute xanim with correct configuration and shut it down again

	parses configuration into text string to use as line parameters for xanim
*/


#include "header.h"


/*
	function: setxanim (pointer to control struct, command to send)

	send a remote command to a running XAnim app
*/

I8 setxanim (xcontrol *control, char *command)
{
	Display *dpy;
	I32 atom = 0;
	I32 xwindow = 0;

	/* go out and find the private data stash on the movie screen */
	/* make sure the movie screen is visible first */
	
	raise_window(control->main->window);

	if (control->play->playing == PLAYING) {
			
		xwindow = get_xwindow(MOVIE);
		dpy = XOpenDisplay(_NULL);
		
		if (atom = XInternAtom(dpy, "XANIM_PROPERTY", TRUE)) {
			XChangeProperty(dpy, xwindow, atom, XA_STRING, 8, 
				PropModeReplace, command, 1);
		}
	
		XCloseDisplay(dpy);
	}

	return TRUE;
}


/*
	function : runxanim (pointer to control struct)

	parse the supplied configuration into a command line string.  set up the movie screen,
	load and execute XAnim, and maintain control->play->playing, which indicates
	whether or not XAnim is playing.  (see comments on the done_check function in gxanim.c)
*/

I8 runxanim (xcontrol *control)
{
	char size[15] = "+Sr";
	char repeat[15] = "+Ae";	
	char volume[15] = "+Ae";
	char windowID[18] = "+Ae";
	char sync[10] = "-Ak";
	char floyd[4] = "+Ae";
	char gamma[25] = "+Ae";

	char *command = _NULL;
 	char *title = _NULL;
	char *filename = _NULL;

	char *name = control->movie->name;

	I16 size_x = 0, size_y = 0;
	I32 xwindow;

	move_defaults(control);

	/* set title */
	
	filename = file_only(name);
	title = dalloc(title, strlen(filename) + 10 + strlen(control->stats->type));
	sprintf(title, "%s - %s", control->stats->type, filename);
	gtk_window_set_title(GTK_WINDOW(control->moviewin->window), title);

	
	
	/* set sync frame */

	if (control->movie->syncframe)
		sprintf(sync, "+Ak");


	/* set gamma correction */

	sprintf(gamma, "+Gd%f", control->movie->gamma);
	

	/* set floyd-steinberg dithering */

	if (control->movie->floydstein)
		sprintf(floyd, "+Cd");


	/* set initial volume */
	
	sprintf(volume, "+Av%i", control->movie->volume);


		
	/* set scaling */

	size_x = (I16) (control->stats->size_x * control->movie->scale);
	size_y = (I16) (control->stats->size_y * control->movie->scale);
 

	
	/* physically change the movie window dimensions */

	sprintf(size, "+Srx%iy%i", size_x, size_y);
	gtk_window_set_default_size(GTK_WINDOW(control->moviewin->window), size_x, size_y);
	size_window(control->moviewin->window, size_x, size_y); 

		
	/* repeat endlessly or die at one? */

	switch (control->movie->holdonend) {
		case FALSE:
			sprintf(repeat, "+Ze");
			break;

		case TRUE:
			sprintf(repeat, "+Zpe");
			break;
	}

	
	/* find private data on the movie screen window */
	
	control->play->playing = PLAYING;	/* needed for done_check */
	
	gtk_widget_show_all(control->moviewin->window);
	xwindow = get_xwindow(MOVIE);
	sprintf(windowID, "+W%i", xwindow);

	
	
	/* let's get 'er done. */

	if (! fork()) {

		control->play = shmat(control->shmid, _NULL, 0);
		/* name = nospace(name); */

		command = 
			dalloc(command, 100 + strlen(windowID) + strlen(size)  + strlen(repeat) + 
			strlen(volume) + strlen(name) + strlen(sync));
		
		sprintf(command, "%s +q -Zr %s %s %s %s %s %s %s \"%s\" ", control->defaults->xanimprog, 
			windowID, size, floyd, gamma, repeat, volume, sync, name);

if (control->defaults->verbose) {
		fprintf(stderr, "%s\n", command);
}

		system(command);
		dfree(command);
		dfree(title);
		dfree(filename);

		control->play->playing = STOPPED;
		_exit(FALSE);
	}; 
			
	return TRUE;
}

