
/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	prefs.c
	
	preference handling routines

*/

#include "header.h"

void get_prefs (GtkWidget *widget, xcontrol *control)
{
	GtkAdjustment *adjust1, *adjust2, *adjust3;
	char *ptr;
	I8 x = 0;
	
	adjust1 = (GtkAdjustment *) control->pref->scaleadj;
	control->defaults->scale = (float) adjust1->value;
	
	adjust2 = (GtkAdjustment *) control->pref->gammaadj;
	control->defaults->gamma = (float) adjust2->value;

	adjust3 = (GtkAdjustment *) control->main->voladjust;
	control->defaults->volume = adjust3->value;

	control->defaults->xanimprog = 
		dalloc(control->defaults->xanimprog, strlen(gtk_entry_get_text(GTK_ENTRY(control->pref->binentry))));

	sprintf(control->defaults->xanimprog, "%s\0", gtk_entry_get_text(GTK_ENTRY(control->pref->binentry)));

	for (; x < strlen(control->defaults->xanimprog); x++)
		if ((int) *(control->defaults->xanimprog + x) == 10)
			*(control->defaults->xanimprog + x) = 32;

	control->defaults->defdir = 
		dalloc(control->defaults->defdir, strlen(gtk_entry_get_text(GTK_ENTRY(control->pref->direntry))) + 5);

	sscanf(gtk_entry_get_text(GTK_ENTRY(control->pref->direntry)), "%s\0", control->defaults->defdir);

	ptr = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(control->main->combo)->entry));

	if ( *(ptr + strlen(ptr) - 1) == '/')
		gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(control->main->combo)->entry), control->defaults->defdir);
		
	
	control->defaults->holdonend = GTK_TOGGLE_BUTTON(control->pref->holdbox)->active;
	control->defaults->syncframe = GTK_TOGGLE_BUTTON(control->pref->syncbox)->active;
	control->defaults->floydstein = GTK_TOGGLE_BUTTON(control->pref->floydbox)->active;
	control->defaults->playonstart = GTK_TOGGLE_BUTTON(control->pref->playbox)->active;
	control->defaults->verbose = GTK_TOGGLE_BUTTON(control->pref->verbbox)->active;
	
	return;
}


void move_defaults (xcontrol *control)
{
	GtkAdjustment *adjust;

	adjust = (GtkAdjustment *)control->main->voladjust;
	control->movie->volume = control->defaults->volume = (int) adjust->value;

	control->movie->scale = control->defaults->scale;
	control->movie->gamma = control->defaults->gamma;
	control->movie->holdonend = control->defaults->holdonend;
	control->movie->syncframe = control->defaults->syncframe;
	control->movie->floydstein = control->defaults->floydstein;
	control->movie->playonstart = control->defaults->playonstart;

	return;
}



void set_defaults (GtkWidget *widget, xcontrol *control)
{
	char text[5];

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(control->pref->syncbox),
		control->defaults->syncframe);

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(control->pref->floydbox),
		control->defaults->floydstein);

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(control->pref->holdbox), 
		control->defaults->holdonend);

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(control->pref->playbox), 
		control->defaults->playonstart);

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(control->pref->verbbox), 
		control->defaults->verbose);
	
	gtk_adjustment_set_value(GTK_ADJUSTMENT(control->pref->gammaadj), 
		control->defaults->gamma);

	gtk_adjustment_set_value(GTK_ADJUSTMENT(control->pref->scaleadj), 
		control->defaults->scale);

	gtk_adjustment_set_value(GTK_ADJUSTMENT(control->main->voladjust), 
		control->defaults->volume);

	gtk_entry_set_text (GTK_ENTRY(control->pref->binentry),
		control->defaults->xanimprog);

	gtk_entry_set_text (GTK_ENTRY(control->pref->direntry),
		control->defaults->defdir);

	get_prefs(widget, control);	

	gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(control->main->combo)->entry),
		control->defaults->defdir);
	
	return;
}


