
import java.sql.*;




/**
 * Test a statement that should return multiple result sets.
 */
public class t0015
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("Test a statement that should return multiple result sets.");

      boolean   passed = true;


      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         j;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs       = null;


      try
      {
         stmt.executeUpdate("drop table t0015");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0015', " +
                                      "because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate("create table t0015              "
                                 + "  (i  integer  not null,      "
                                 + "   s  char(10) not null)      ");
      System.out.println("Creating table affected " + count + " rows");



      PreparedStatement pStmt = cx.prepareStatement(
         "insert into t0015 values (?, ?)");

      int rowsToAdd = 8;
      final String theString = "abcdefghijklmnopqrstuvwxyz";
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         pStmt.setString(2, theString.substring(0, i));

         count += pStmt.executeUpdate();
      }

      stmt = cx.createStatement();
      rs = stmt.executeQuery("select s from t0015 select i from t0015");
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getString("s"));
         count ++;
      }
      passed = passed && (count==rowsToAdd);

      passed = passed && (stmt.getMoreResults());
      if (!passed)
      {
         throw new SQLException("Already failed");
      }

      rs = stmt.getResultSet();
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getInt("i"));
         count ++;
      }
      passed = passed && (count==rowsToAdd);


      rs = stmt.executeQuery("select i, s from t0015");
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getInt("i") + ":" + rs.getString("s"));
         count ++;
      }
      passed = passed && (count==rowsToAdd);

      cx.close();


     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0015.\n");
      System.exit(passed ? 0 : 1);
   }
}


