open Tk
open Jtk
open Fonts

(* This table is shared by all widgets *)
let tags = Hashtbl.create 37

(* For a given fontDesc, return the name of the tags and its attributes *)
let rec compute_tag fd =
  try
    Hashtbl.find tags fd 
  with
    Not_found ->
     try
      let pxlsz = pxlsz fd.pxlsz in
      let f = Japan.font_find fd.family fd.weight fd.slant pxlsz in
      let tagdesc = 
      	(fd.family^fd.weight^fd.slant^(string_of_int pxlsz), [KanjiFont f]) in
      	Hashtbl.add tags fd tagdesc;
	tagdesc
     with Invalid_argument f ->  (* font is not available *)
       (* Misc.warning (I18n.sprintf "Font %s is not available" f); *)
       Log.f (I18n.sprintf "Font %s is not available" f);
       if fd = !default then (* ARGH *)
(* ... may be a bug --- JUN *)
       	 let tagdesc = ("fixedfont", [KanjiFont "k14"]) in
	   Hashtbl.add tags fd tagdesc;
	   tagdesc
       else begin
      	let tagdesc = compute_tag !default in
	   Hashtbl.add tags fd tagdesc;
	   tagdesc
       end
