/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"

static Boolean
update_glyph_arrays(int i, int k, Boolean changed, xgobidata *xg) {
  unsigned long ltype;
  Boolean new_changed = changed;

  if (xg->under_new_brush[i]) {
    if (xg->brush_mode == undo) {
      xg->glyph_now[i].type = xg->glyph_prev[i].type;
      xg->glyph_now[i].size = xg->glyph_prev[i].size;
    }
    else {
      xg->glyph_now[i].type = xg->glyph_id.type;
      xg->glyph_now[i].size = xg->glyph_id.size;
    }

    if (xg->brush_mode != transient) {
      xg->glyph_ids[i].type = xg->glyph_now[i].type;
      xg->glyph_ids[i].size = xg->glyph_now[i].size;
    }
  }
  else {
    xg->glyph_now[i].type = xg->glyph_ids[i].type;
    xg->glyph_now[i].size = xg->glyph_ids[i].size;
  }

  /*
   * Keep senddata up to date
  */

  /* Watch for changed in a single place */
  ltype = (unsigned long) glyph_color_pointtype(xg, i);
  if (!changed && xg->senddata[6 + xg->nrows_in_plot + k] != ltype)
    new_changed = True;
  xg->senddata[6 + xg->nrows_in_plot + k] = (unsigned long) ltype;

  return(new_changed);
}

static Boolean
build_glyph_vectors(xg)
  xgobidata *xg;
{
  int ih, iv, m, j, k, gp, n;
  static icoords obin0 = {NHBINS/2, NVBINS/2};
  static icoords obin1 = {NHBINS/2, NVBINS/2};
  icoords imin, imax;
  Boolean changed = False;
  unsigned long ltype;

  if (xg->brush_mode == transient) {
    imin.x = MIN(xg->bin0.x, obin0.x);
    imin.y = MIN(xg->bin0.y, obin0.y);
    imax.x = MAX(xg->bin1.x, obin1.x);
    imax.y = MAX(xg->bin1.y, obin1.y);
  }
  else {
    imin.x = xg->bin0.x;
    imin.y = xg->bin0.y;
    imax.x = xg->bin1.x;
    imax.y = xg->bin1.y;
  }

  for (ih=imin.x; ih<=imax.x; ih++) {
    for (iv=imin.y; iv<=imax.y; iv++) {
      for (m=0; m<xg->bincounts[ih][iv]; m++) {
      /*
       * j is the row number; k is the index of rows_in_plot[]
      */
        j = xg->rows_in_plot[ k = xg->binarray[ih][iv][m] ] ;

        /* update the glyph arrays for every member of the row group */
        if (xg->nrgroups > 0) {
          gp = xg->rgroup_ids[j];
          for (n=0; n<xg->rgroups[gp].nels; n++) {
            changed = update_glyph_arrays(xg->rgroups[gp].els[n],
              k, changed, xg);
          }
        } else
          /* update the glyph arrays only for this guy */
          changed = update_glyph_arrays(j, k, changed, xg);

      }
    }
  }

  obin0.x = xg->bin0.x;
  obin0.y = xg->bin0.y;
  obin1.x = xg->bin1.x;
  obin1.y = xg->bin1.y;

  return(changed);
}

static Boolean
update_color_arrays(int i, int k, Boolean changed, xgobidata *xg) {
  unsigned long ltype;
  Boolean new_changed = changed;

  if (xg->under_new_brush[i]) {
    if (xg->brush_mode == undo)
      xg->color_now[i] = xg->color_prev[i];
    else {
      xg->color_now[i] = xg->color_id;
    }

    if (xg->brush_mode != transient)
      xg->color_ids[i] = xg->color_now[i];
  }
  else
    xg->color_now[i] = xg->color_ids[i];

  /*
   * Keep senddata up to date, and watch for changes as a result
   * of color brushing.
  */
  ltype = (unsigned long) glyph_color_pointtype(xg, i);
  if (!changed && xg->senddata[6 + xg->nrows_in_plot + k] != ltype)
    new_changed = True;
  xg->senddata[6 + xg->nrows_in_plot + k] = (unsigned long) ltype;

  return(new_changed);
}

static Boolean
build_color_vectors(xg)
  xgobidata *xg;
{
  int ih, iv, m, j, k, gp, n;
  static icoords obin0 = {NHBINS/2, NVBINS/2};
  static icoords obin1 = {NHBINS/2, NVBINS/2};
  icoords imin, imax;
  Boolean changed = False;

  if (xg->brush_mode == transient) {
    imin.x = MIN(xg->bin0.x, obin0.x);
    imin.y = MIN(xg->bin0.y, obin0.y);
    imax.x = MAX(xg->bin1.x, obin1.x);
    imax.y = MAX(xg->bin1.y, obin1.y);
  }
  else {
    imin.x = xg->bin0.x;
    imin.y = xg->bin0.y;
    imax.x = xg->bin1.x;
    imax.y = xg->bin1.y;
  }

  for (ih=imin.x; ih<=imax.x; ih++) {
    for (iv=imin.y; iv<=imax.y; iv++) {
      for (m=0; m<xg->bincounts[ih][iv]; m++) {
        j = xg->rows_in_plot[ k = xg->binarray[ih][iv][m] ] ;

        /* update the color arrays for every member of the row group */
        if (xg->nrgroups > 0) {
          gp = xg->rgroup_ids[j];
          if (xg->rgroups[gp].nels > 1) 
            for (n=0; n<xg->rgroups[gp].nels; n++) {
              changed = update_color_arrays(xg->rgroups[gp].els[n],
                k, changed, xg);
          }
        } else {
          /* update the color arrays only for this guy */
          changed = update_color_arrays(j, k, changed, xg);
        }

      }
    }
    obin0.x = xg->bin0.x;
    obin0.y = xg->bin0.y;
    obin1.x = xg->bin1.x;
    obin1.y = xg->bin1.y;
  }

  return(changed);
}

static Boolean
update_erase_array(int i, int k, Boolean changed, xgobidata *xg) {
  unsigned long ltype;

  if (xg->under_new_brush[i]) {
    if (!changed && xg->erased[i] == 0) changed = True;
    xg->erased[i] = 1;
    /*
     * Keep senddata up to date
    */
    xg->senddata[6 + xg->nrows_in_plot + k] = (unsigned long)
      glyph_color_pointtype(xg, i);
  }
}

static Boolean
build_erase_vector(xg)
  xgobidata *xg;
{
  int ih, iv, m, j, k, gp, n;
  Boolean changed = False;

  for (ih=xg->bin0.x; ih<=xg->bin1.x; ih++) {
    for (iv=xg->bin0.y; iv<=xg->bin1.y; iv++) {
      for (m=0; m<xg->bincounts[ih][iv]; m++) {
        j = xg->rows_in_plot[ k = xg->binarray[ih][iv][m] ] ;

        /* update the erase arrays for every member of the row group */
        if (xg->nrgroups > 0) {
          gp = xg->rgroup_ids[j];
          for (n=0; n<xg->rgroups[gp].nels; n++) {
            changed = update_erase_array(xg->rgroups[gp].els[n],
              k, changed, xg);
          }
        } else
          /* update the erase array only for this guy */
          changed = update_erase_array(j, k, changed, xg);

      }
    }
  }
  return(changed);
}

void
init_glyph_ids(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nrows; j++) {
    xg->glyph_ids[j].type = xg->glyph_now[j].type =
      xg->glyph_prev[j].type = xg->glyph_0.type;
    xg->glyph_ids[j].size = xg->glyph_now[j].size =
      xg->glyph_prev[j].size = xg->glyph_0.size;
  }
}

void
init_color_ids(xg)
  xgobidata *xg;
{
  int j;

  xg->color_id = plotcolors.fg;
  for (j=0; j<xg->nrows; j++) {
    xg->color_ids[j] = xg->color_now[j] =
      xg->color_prev[j] = plotcolors.fg;
  }
}

void
init_erase(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nrows; j++)
    xg->erased[j] = 0;
}

Boolean
active_paint_points(xg)
  xgobidata *xg;
{
  int ih, iv, j, pt, k, gp;
  Boolean changed;
/*
 * Set under_new_brush[j] to 1 if point j is inside the rectangular brush.
*/
  /* Zero out under_new_brush[] before looping */
  for (j=0; j<xg->nrows_in_plot; j++)
    xg->under_new_brush[xg->rows_in_plot[j]] = 0;

  /*
   * bincounts[][] and binarray[][][] only represent the the
   * rows in rows_in_plot[] so there's no need to test for that.
  */
  for (ih=xg->bin0.x; ih<=xg->bin1.x; ih++) {
    for (iv=xg->bin0.y; iv<=xg->bin1.y; iv++) {
      for (j=0; j<xg->bincounts[ih][iv]; j++) {
        pt = xg->rows_in_plot[xg->binarray[ih][iv][j]];
        if (!xg->erased[pt] && under_brush(xg, pt)) {
          xg->under_new_brush[pt] = 1;

          /* brush other members of this row group */
          if (xg->nrgroups) {
            gp = xg->rgroup_ids[pt];
            for (k=0; k<xg->rgroups[gp].nels; k++) {
              if (!xg->erased[ xg->rgroups[gp].els[k] ])
                xg->under_new_brush[ xg->rgroups[gp].els[k] ] = 1;
            }
          }
          /* */

        }
      }
    }
  }

  /*
   * If we're erasing, build the erase vector (So far, this is strictly
   * a persistent operation, with no undo facility.)
  */
  changed = False;
  if (xg->is_erase)
    changed = build_erase_vector(xg);
  else
  {
    /*
     * Now, using the under_new_brush[] vector that only contains un-erased
     * points, build the color and glyph vectors.
    */
    if (xg->is_color_painting)
      changed = build_color_vectors(xg) || changed;

    if (xg->is_glyph_painting)
      changed = build_glyph_vectors(xg) || changed;
  }
  return(changed);
}

void
init_line_colors(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nlinks; j++)
  {
    xg->line_color_ids[j] = xg->line_color_now[j] =
      xg->line_color_prev[j] = plotcolors.fg;
  }
}

static void
build_line_color_vectors(xg)
  xgobidata *xg;
{
  int j;

  for (j=0; j<xg->nlinks; j++) {
    if (xg->xed_by_new_brush[j]) {

      if (xg->brush_mode == undo)
        xg->line_color_now[j] = xg->line_color_prev[j];
      else
        xg->line_color_now[j] = xg->color_id;

      if (xg->brush_mode != transient)
        xg->line_color_ids[j] = xg->line_color_now[j];
    }
    else
      xg->line_color_now[j] = xg->line_color_ids[j];
  }
}

void
active_paint_lines(xg)
  xgobidata *xg;
{
  int j, k, from, to, gp;
/*
 * Set xed_by_new_brush[j] to 1 if line j intersects the crosshair brush.
 * If we're also point painting and the rectangular brush is shown,
 * then also set xed_by_new_brush[j] to 1 if both a and b are contained
 * within the brush.
*/
  for (j=0; j<xg->nlinks; j++)
    xg->xed_by_new_brush[j] = 0;

  for (j=0; j<xg->nlinks; j++) {
    from = xg->connecting_lines[j].a - 1;
    to = xg->connecting_lines[j].b - 1;
    /* xg->xed_by_new_brush[j] = 0; */  /* this messes up lgroups totally */
    if (!xg->erased[from] && !xg->erased[to]) {
      if (xed_by_brush(xg, from, to))
        xg->xed_by_new_brush[j] = 1;
      else {
        if (xg->is_point_painting) {
          if (under_brush(xg, from) && under_brush(xg, to))
            xg->xed_by_new_brush[j] = 1;
        }
      }

      /* brush other members of this line group */
      if (xg->nlgroups) {
        if (xg->xed_by_new_brush[j]) {
          gp = xg->lgroup_ids[j];
          if (gp > -1 && xg->lgroups[gp].nels > 1) {
            for (k=0; k<xg->lgroups[gp].nels; k++) {
              xg->xed_by_new_brush[ xg->lgroups[gp].els[k] ] = 1;
            }
          }
        }
      }
      /* */

    }
  }

/*
  for (j=0;j<xg->nlinks;j++)
  printf("%d ", xg->xed_by_new_brush[j]);
  printf("\n");
*/

  if (xg->is_color_painting)
    build_line_color_vectors(xg);
}
