/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/ui_rpcsnns.x,v $
  SHORTNAME      : ui_rpcsnns.x
  SNNS VERSION   : 4.0

  PURPOSE        : Inputfile for rpcgen
  NOTES          : The xgui functions

  AUTHOR         : Sven Doering
  DATE           : 17.08.94

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/05/08 10:29:08 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

%#include <sys/time.h>
%#define MAXHOSTDLEN 16 /* For the other files */
#define MAXHOSTDLEN 16 /* local */
%#define MAXDOMAINDLEN 30 /* For the other files */
#define MAXDOMAINDLEN 30 /* local */

/* Errors */
%#define RPC_NO_ERROR 			0
%#define RPC_ID_NOT_REGISTERD 		-1
%#define RPC_UNKNOWN_ERROR 		-2
%#define RPC_ERROR_HOST_NOT_FOUND 	-3
%#define RPC_OLD_XGUI_IS_RUNNING 	-4
%#define RPC_UNKNOWN_OPTION		-5
%#define RPC_CANNOT_OPEN_FILE		-6
%#define RPC_TRANSFER_ERROR		-7
%#define RPC_LOST_PAKETS		-8
%#define RPC_CANNOT_SAVE_FILE		-9
%#define RPC_WRONG_PAKET		-10

/* MSG */
%#define LEARNINFO 1
%#define UPDATE 2
%#define PING 3
%#define SHUTDOWN 4

struct rpc_timeval2 {
        long    tv_sec;         /* seconds */
        long    tv_usec;        /* and microseconds */
};

struct xgui_info {
	int error;
	int kernelid;
};

/**************************************************** 
 * ATTENTION this struct also exist in kr_ui_rpc.x
 *   as par_config
 ****************************************************/

struct par_config2{

/* Configuration of the Kernel */
	u_int   lastEpoch;
	float	lastLearnError;
	u_int   epochsToLearn;
	long	starttime;
	long	cputime;
	int	kernelMode;
	rpc_timeval2 timeout;
	rpc_timeval2 timeoutlong;
	long	exittimeout;
	long    switchtolocalall;
	long    switchtolocalsingle;
	bool	isUDP;
	int	status;

/* current configuration of remote panel */
	int       ui_noOfCurrentPattern;  /* number of current pattern
                                         0 means, no patterns loaded */
	int       ui_patternLoadMode;
	int       ui_numberOfStepsDone;
	int       subIPatSize[5];
	int       subIPatPos[5];
	int       subIPatStep[5];	
	int       subOPatStep[5];
	int       subOPatSize[5];
	int       subOPatPos[5];
	int       subIPatNo;
	int       subIPatDims;
	int       subOPatDims;
	float     ui_learnParameters[25];
	float     ui_updateParameters[5];
	float     ui_initParameters[5];
	bool      ui_shuffleFlg;

	/* from ui_fileP.ph */
	char   ui_filenameNET[100];
	char   ui_filenamePAT[100];
	char   ui_filenameRES[100];
	char   ui_filenameCFG[100];
	char   ui_filenameTXT[100];

	int    NO_OF_PATTERN_SETS;
	int    CURR_PATTERN_SET;
	char   PATTERN_SET_FILE[100];

	/* ui_remote.ph */
	int       ui_numberOfCycles;
	int       ui_numberOfSteps;

	/* are static */
	/* static int   INIT_KOHONEN_PRINT;
	   static int   ui_noErrorArrayElements;
	*/

	/* only for displaying */
	int noOfPatterns;
	int noOfUnits;
	int noOfInput;
	int noOfOutput;
	int noOfHidden;
};

struct register_info {
	int error;
	int kernelid;
	int xguiid;
	string host<>;
	string domain<>;
	string hostaddr<16>;
	long vers;
	long programm;
	unsigned int pid;
 	par_config2 kernel_config;
};

struct callback_info {
	int callbackType;
	int kernelid;
	bool waitforreply;
	int lastEpoch;
	float lastLearnError;
	par_config2 kernel_config;
};

program SNNSUIPROG {
	version SNNSUIVERS {
		xgui_info REGISTER_NEW_KERNEL(register_info)	= 1;
		int KERNEL_CALLBACK(callback_info)		= 2;
	}=40;
}=0x221d1ae3;

